package uk.ac.warwick.util.ais.auth;

import org.junit.Test;
import uk.ac.warwick.util.ais.auth.model.AuthenticationResult;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class AuthenticatorRegistryTest {

    @Test
    public void register_validServiceId_storesAuthenticator() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        // create a mock authenticator
        Authenticator<?, ? extends AuthenticationResult> authenticator = (Authenticator<Object, AuthenticationResult>) request -> null;

        registry.register("service1", authenticator);

        assertEquals(authenticator, registry.getAuthenticator("service1"));
    }

    @Test
    public void getAuthenticator_nonExistentServiceId_returnsNull() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();

        assertNull(registry.getAuthenticator("nonExistentService"));
    }

    @Test
    public void register_multipleServiceIds_storesAuthenticators() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        // create some mock authenticators
        Authenticator<?, ? extends AuthenticationResult> authenticator1 = (Authenticator<Object, AuthenticationResult>) request -> null;
        Authenticator<?, ? extends AuthenticationResult> authenticator2 = (Authenticator<Object, AuthenticationResult>) request -> null;

        registry.register("service1", authenticator1);
        registry.register("service2", authenticator2);

        assertEquals(authenticator1, registry.getAuthenticator("service1"));
        assertEquals(authenticator2, registry.getAuthenticator("service2"));
    }

    @Test
    public void register_sameServiceId_overwritesAuthenticator() {
        AuthenticatorRegistry registry = new AuthenticatorRegistry();
        // create some mock authenticators
        Authenticator<?, ? extends AuthenticationResult> authenticator1 = (Authenticator<Object, AuthenticationResult>) request -> null;
        Authenticator<?, ? extends AuthenticationResult> authenticator2 = (Authenticator<Object, AuthenticationResult>) request -> null;

        registry.register("service1", authenticator1);
        registry.register("service1", authenticator2);

        assertEquals(authenticator2, registry.getAuthenticator("service1"));
    }
}
