package uk.ac.warwick.util.ais.apim.stutalk;

import com.fasterxml.jackson.core.type.TypeReference;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

import static org.mockito.Mockito.mock;

public class StuTalkHttpClientImplTest {

    private AisHttpAsyncClient httpAsyncClient;

    @Before
    public void setUp() {
        httpAsyncClient = mock(AisHttpAsyncClient.class);
    }

    @Test(expected = UnsupportedOperationException.class)
    public void deleteAsync_unsupported() {
        StuTalkHttpClientImpl stuTalkHttpClient = new StuTalkHttpClientImpl(httpAsyncClient);
        stuTalkHttpClient.deleteAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
    }

    @Test(expected = UnsupportedOperationException.class)
    public void delete_unsupported() {
        StuTalkHttpClientImpl stuTalkHttpClient = new StuTalkHttpClientImpl(httpAsyncClient);
        stuTalkHttpClient.delete(mock(AisHttpRequest.class), new TypeReference<String>() {});
    }

}
