package uk.ac.warwick.util.ais.apim.config;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import uk.ac.warwick.util.ais.apim.rodb.RodbHttpClient;
import uk.ac.warwick.util.ais.apim.stutalk.StuTalkHttpClient;

import static org.junit.Assert.assertNotNull;

@RunWith(SpringRunner.class)
@TestPropertySource(locations = "classpath:application.properties")
@ContextConfiguration(classes = {AisSpringConfiguration.class})
public class AisSpringConfigurationTest {

    @Autowired
    private StuTalkHttpClient stuTalkClient;

    @Autowired
    private RodbHttpClient rodbHttpClient;

    @Test
    public void loadConfiguration_success() {

        assertNotNull(stuTalkClient);
        assertNotNull(rodbHttpClient);
    }
}
