package uk.ac.warwick.util.ais.apim.config;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.typesafe.config.ConfigFactory;
import org.junit.Before;
import org.junit.Test;
import play.api.Configuration;
import uk.ac.warwick.util.ais.apim.rodb.RodbHttpClient;
import uk.ac.warwick.util.ais.apim.stutalk.StuTalkHttpClient;

import javax.inject.Inject;
import javax.inject.Named;

import static org.junit.Assert.assertNotNull;

public class AisPlayModuleTest {

    @Inject
    @Named("stuTalkHttpClient")
    StuTalkHttpClient stuTalkHttpClient;

    @Inject
    @Named("rodbHttpClient")
    RodbHttpClient rodHttpClient;

    @Before
    public void setUp() {
        Guice.createInjector(new ConfigModule(), new AisPlayModule()).injectMembers(this);
    }

    @Test
    public void loadModule_success() {
        assertNotNull(stuTalkHttpClient);
        assertNotNull(rodHttpClient);
    }

    public static class ConfigModule extends AbstractModule {
        protected void configure() {
            // This emulates what Play does, providing a Configuration.
            bind(Configuration.class).toInstance(Configuration.apply(ConfigFactory.load("conf/application.conf")));
        }
    }
}
