package uk.ac.warwick.util.ais.auth.model;

import java.util.HashSet;
import java.util.Set;

public class ClientCredentialsRequest {

    /**
     * scope for which the application is requesting access to.
     */
    private final String scope;

    /**
     * Indicates whether the request should skip looking into the token cache. By default, it is set to false.
     */
    private final Boolean skipCache;

    public ClientCredentialsRequest(String scope, Boolean skipCache) {
        this.scope = scope;
        this.skipCache = skipCache;
    }

    private ClientCredentialsRequest(Builder builder) {
        this.scope = String.join(builder.scopeSeparator, builder.scopes);
        this.skipCache = builder.skipCache;
    }

    public String getScope() {
        return scope;
    }

    public Boolean getSkipCache() {
        return skipCache;
    }

    public static class Builder {
        private Set<String> scopes = new HashSet<>();
        private Boolean skipCache = false;
        private String scopeSeparator = " "; // Default scope separator is a space

        public Builder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder addScope(String scope) {
            this.scopes.add(scope);
            return this;
        }

        public Builder skipCache(Boolean skipCache) {
            this.skipCache = skipCache;
            return this;
        }

        public Builder scopeSeparator(String scopeSeparator) {
            this.scopeSeparator = scopeSeparator;
            return this;
        }

        public ClientCredentialsRequest build() {
            if (scopes == null || scopes.isEmpty()) {
                throw new IllegalArgumentException("scopes cannot be null or empty.");
            }
            return new ClientCredentialsRequest(this);
        }
    }
}
