package uk.ac.warwick.util.ais.apim.stutalk;

import com.fasterxml.jackson.core.type.TypeReference;
import uk.ac.warwick.util.ais.apim.AbstractAisHttpClientTemplate;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

import java.util.concurrent.CompletableFuture;

/**
 * This is a concrete Java implementation class of StuTalkHttpClient that supports Java CompletableFuture.
 */
public class StuTalkHttpClientImpl extends AbstractAisHttpClientTemplate implements StuTalkHttpClient {

    /**
     * AIS layer validation won't allow request with DELETE method to have a body,
     * while we agreed together that the primary key must be included in body for every delete operation,
     * so that's why the delete operation to be POST method, actually.
     */
    private static final String STUTALK_DELETE_UNSUPPORTED_MESSAGE = "StuTalk APIs does not support DELETE requests";

    public StuTalkHttpClientImpl(AisHttpAsyncClient httpAsyncClient) {
        super(httpAsyncClient);
    }

    @Override
    public <T> CompletableFuture<T> deleteAsync(AisHttpRequest request, TypeReference<T> typeReference) {
        throw new UnsupportedOperationException(STUTALK_DELETE_UNSUPPORTED_MESSAGE);
    }

    @Override
    public <T> T delete(AisHttpRequest request, TypeReference<T> typeReference) {
        throw new UnsupportedOperationException(STUTALK_DELETE_UNSUPPORTED_MESSAGE);
    }
}
