package uk.ac.warwick.util.ais.apim.rodb.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RodbPagination {
    @JsonProperty("total_records")
    private Integer totalRecords;

    @JsonProperty("current_page")
    private Integer currentPage;

    @JsonProperty("total_pages")
    private Integer totalPages;

    @JsonProperty("total_records_current_page")
    private Integer totalRecordsCurrentPage;

    @JsonProperty("next_page")
    private Integer nextPage;

    @JsonProperty("prev_page")
    private Integer prevPage;

    public RodbPagination() {
    }

    public RodbPagination(Integer totalRecords, Integer currentPage, Integer totalPages,
                          Integer totalRecordsCurrentPage, Integer nextPage, Integer prevPage) {
        this.totalRecords = totalRecords;
        this.currentPage = currentPage;
        this.totalPages = totalPages;
        this.totalRecordsCurrentPage = totalRecordsCurrentPage;
        this.nextPage = nextPage;
        this.prevPage = prevPage;
    }

    public Integer getTotalRecords() {
        return totalRecords;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public Integer getTotalPages() {
        return totalPages;
    }

    public Integer getTotalRecordsCurrentPage() {
        return totalRecordsCurrentPage;
    }

    public Integer getNextPage() {
        return nextPage;
    }

    public Integer getPrevPage() {
        return prevPage;
    }
}
