package uk.ac.warwick.util.ais.apim;

import com.fasterxml.jackson.core.type.TypeReference;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

import java.util.concurrent.CompletableFuture;

/**
 * This is an interface based on Http methods, it supports GET, POST, PUT and DELETE requests.
 */
public interface AisHttpOperations {

    <T> CompletableFuture<T> getAsync(AisHttpRequest request, TypeReference<T> typeReference);

    <T> CompletableFuture<T> postAsync(AisHttpRequest request, TypeReference<T> typeReference);

    <T> CompletableFuture<T> putAsync(AisHttpRequest request, TypeReference<T> typeReference);

    <T> CompletableFuture<T> deleteAsync(AisHttpRequest request, TypeReference<T> typeReference);

    <T> T get(AisHttpRequest request, TypeReference<T> typeReference);

    <T> T post(AisHttpRequest request, TypeReference<T> typeReference);

    <T> T put(AisHttpRequest request, TypeReference<T> typeReference);

    <T> T delete(AisHttpRequest request, TypeReference<T> typeReference);
}
