/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.resilience;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.retry.Retry;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ResilienceDecorators {
    public static <T> DecorateSupplier<T> ofSupplier(Supplier<T> supplier) {
        return new DecorateSupplier(supplier);
    }

    public static <T, R> DecorateFunction<T, R> ofFunction(Function<T, R> function) {
        return new DecorateFunction(function);
    }

    public static class DecorateFunction<T, R> {
        private Function<T, R> function;

        private DecorateFunction(Function<T, R> function) {
            this.function = function;
        }

        public DecorateFunction<T, R> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.function = CircuitBreaker.decorateFunction((CircuitBreaker)circuitBreaker, this.function);
            return this;
        }

        public DecorateFunction<T, R> withRetry(Retry retryContext) {
            this.function = Retry.decorateFunction((Retry)retryContext, this.function);
            return this;
        }

        public Function<T, R> decorate() {
            return this.function;
        }

        public R apply(T t) {
            return this.function.apply(t);
        }
    }

    public static class DecorateSupplier<T> {
        private Supplier<T> supplier;

        private DecorateSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public DecorateSupplier<T> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.supplier = CircuitBreaker.decorateSupplier((CircuitBreaker)circuitBreaker, this.supplier);
            return this;
        }

        public DecorateSupplier<T> withRetry(Retry retryContext) {
            this.supplier = Retry.decorateSupplier((Retry)retryContext, this.supplier);
            return this;
        }

        public Supplier<T> decorate() {
            return this.supplier;
        }

        public T get() {
            return this.supplier.get();
        }
    }
}

