/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import java.util.ArrayList;
import uk.ac.warwick.util.ais.core.json.ChainedTransformer;
import uk.ac.warwick.util.ais.core.json.EmptyStringToNullTransformer;
import uk.ac.warwick.util.ais.core.json.NewlineDeserializerTransformer;
import uk.ac.warwick.util.ais.core.json.NewlineSerializerTransformer;
import uk.ac.warwick.util.ais.core.json.StringTransformer;

public class TransformerPipelineFactory {
    public static StringTransformer createDeserializer(boolean shouldConvertEmptyStringsToNull, boolean shouldNormalizeNewlines) {
        ArrayList<StringTransformer> transformSteps = new ArrayList<StringTransformer>();
        if (shouldConvertEmptyStringsToNull) {
            transformSteps.add(new EmptyStringToNullTransformer());
        }
        if (shouldNormalizeNewlines) {
            transformSteps.add(new NewlineDeserializerTransformer());
        }
        return new ChainedTransformer(transformSteps);
    }

    public static StringTransformer createSerializer(boolean shouldNormalizeNewlines) {
        ArrayList<StringTransformer> transformSteps = new ArrayList<StringTransformer>();
        if (shouldNormalizeNewlines) {
            transformSteps.add(new NewlineSerializerTransformer());
        }
        return new ChainedTransformer(transformSteps);
    }
}

