/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import uk.ac.warwick.util.ais.core.exception.AisJsonProcessingException;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;

public abstract class AbstractAisJsonConverter
implements AisJsonConverter {
    private static final String JSON_NODE_MUST_NOT_BE_NULL = "jsonNode must not be null";
    private static final String JSON_STRING_MUST_NOT_BE_NULL = "json string must not be null";
    protected final ObjectMapper objectMapper;

    protected AbstractAisJsonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T fromJsonNode(JsonNode json, TypeReference<T> typeReference) {
        if (json == null) {
            throw new IllegalArgumentException(JSON_NODE_MUST_NOT_BE_NULL);
        }
        try {
            return (T)this.objectMapper.readValue(json.traverse(), typeReference);
        }
        catch (IOException e) {
            throw new AisJsonProcessingException(String.format("Unable to deserialise the given jsonNode to %s", typeReference.getType().getTypeName()), e);
        }
    }

    @Override
    public <T> T fromJsonNode(JsonNode json, Class<T> clazz) {
        if (json == null) {
            throw new IllegalArgumentException(JSON_NODE_MUST_NOT_BE_NULL);
        }
        try {
            return (T)this.objectMapper.treeToValue((TreeNode)json, clazz);
        }
        catch (IOException e) {
            throw new AisJsonProcessingException(String.format("Unable to deserialise the given jsonNode to %s", clazz.getTypeName()), e);
        }
    }

    @Override
    public <T> T fromJsonString(String json, TypeReference<T> typeReference) {
        if (json == null) {
            throw new IllegalArgumentException(JSON_STRING_MUST_NOT_BE_NULL);
        }
        try {
            return (T)this.objectMapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new AisJsonProcessingException(String.format("Unable to deserialise the given jsonString to %s", typeReference.getType().getTypeName()), e);
        }
    }

    @Override
    public <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            throw new IllegalArgumentException(JSON_STRING_MUST_NOT_BE_NULL);
        }
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new AisJsonProcessingException(String.format("Unable to deserialise the given jsonString to %s", clazz.getTypeName()), e);
        }
    }

    @Override
    public String toJsonString(Object obj) {
        if (obj == null) {
            return "{}";
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new AisJsonProcessingException("Unable to serialise the given object to String.", e);
        }
    }

    @Override
    public JsonNode toJsonNode(String json) {
        if (json == null) {
            throw new IllegalArgumentException("json string must not be null.");
        }
        try {
            return this.objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new AisJsonProcessingException("Unable to deserialise JSON string to JsonNode.", e);
        }
    }
}

