/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestExecutor;

public class AisHttpAsyncClientBase<Req, Res>
implements AisHttpAsyncClient {
    private final HttpRequestBuilder<Req> requestBuilder;
    private final AisHttpResponseHandler<Res> responseHandler;
    private final HttpRequestExecutor<Req, Res> executor;

    public AisHttpAsyncClientBase(HttpRequestBuilder<Req> requestBuilder, AisHttpResponseHandler<Res> responseHandler, HttpRequestExecutor<Req, Res> executor) {
        this.requestBuilder = requestBuilder;
        this.responseHandler = responseHandler;
        this.executor = executor;
    }

    @Override
    public <T> CompletableFuture<T> sendRequestAsync(String method, AisHttpRequest request, TypeReference<T> responseType) {
        Req httpRequest = this.requestBuilder.buildHttpRequest(method, request);
        CompletableFuture<Res> futureResponse = this.executor.execute(httpRequest);
        return ((CompletableFuture)futureResponse.thenApply(response -> this.responseHandler.handleResponse(response, responseType))).exceptionally(ex -> {
            Throwable cause = ex;
            if (ex instanceof CompletionException) {
                cause = ex.getCause();
            }
            throw this.responseHandler.handleError(cause);
        });
    }

    @Override
    public <T> T sendRequest(String method, AisHttpRequest request, TypeReference<T> responseType, long timeout, TimeUnit unit) throws AisHttpException {
        try {
            return this.sendRequestAsync(method, request, responseType).get(timeout, unit);
        }
        catch (Throwable ex) {
            throw this.handleSyncRequestException(ex);
        }
    }

    private AisHttpException handleSyncRequestException(Throwable ex) {
        Throwable cause = ex;
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof TimeoutException) {
            return new AisHttpException(AisHttpException.ErrorType.CONNECTION_ERROR, "Request was timed out.", ex);
        }
        if (ex instanceof ExecutionException) {
            cause = ex.getCause();
        }
        if (cause instanceof AisHttpException) {
            return (AisHttpException)cause;
        }
        return new AisHttpException(AisHttpException.ErrorType.OTHERS, "An error occurred while executing the request.", cause);
    }
}

