/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;

public abstract class AbstractAisHttpResponseHandler<R>
implements AisHttpResponseHandler<R> {
    private static final String SUPPORTED_CONTENT_TYPE = "application/json";
    protected final AisJsonConverter jsonConverter;

    protected AbstractAisHttpResponseHandler(AisJsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    protected abstract JsonNode handleResponseEntity(R var1) throws IOException;

    @Override
    public <T> T handleResponse(R response, TypeReference<T> typeReference) {
        try {
            JsonNode entity = this.handleResponseEntity(response);
            return this.jsonConverter.fromJsonNode(entity, typeReference);
        }
        catch (IOException ex) {
            throw new AisHttpException(AisHttpException.ErrorType.OTHERS, "ENTITY_MAPPING_EXCEPTION", ex);
        }
    }

    @Override
    public AisHttpException handleError(Throwable ex) {
        if (ex instanceof AisHttpException) {
            return (AisHttpException)ex;
        }
        if (ex instanceof SocketException || ex instanceof InterruptedIOException) {
            return new AisHttpException(AisHttpException.ErrorType.CONNECTION_ERROR, "Network exception occurred.", ex);
        }
        return new AisHttpException(AisHttpException.ErrorType.OTHERS, "An error occurred while communicating with AIS API Management Service.", ex);
    }

    protected JsonNode handleEntity(String bodyString, String contentType) {
        if (SUPPORTED_CONTENT_TYPE.equalsIgnoreCase(contentType)) {
            return this.jsonConverter.toJsonNode(bodyString);
        }
        throw new AisHttpException(AisHttpException.ErrorType.MALFORMED_RESPONSE_ERROR, String.format("Content type %s is not supported.", contentType), null, bodyString);
    }
}

