/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.helpers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.core.StopWatch;

public final class AisHttpRequestLogger
implements AisHttpAsyncClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AisHttpRequestLogger.class);
    private final ObjectMapper objectMapper;
    private final AisHttpAsyncClient delegate;

    public AisHttpRequestLogger(ObjectMapper objectMapper, AisHttpAsyncClient delegate) {
        this.objectMapper = objectMapper;
        this.delegate = delegate;
    }

    @Override
    public <T> CompletableFuture<T> sendRequestAsync(String method, AisHttpRequest request, TypeReference<T> responseType) {
        this.logRequestInfo(method, request);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(request.getRequestId());
        CompletableFuture<T> future = this.delegate.sendRequestAsync(method, request, responseType);
        future.whenComplete((result, throwable) -> {
            long executionTime = stopWatch.stop();
            if (throwable != null) {
                this.logExceptionInfo(method, request, (Throwable)throwable);
            } else {
                this.logResponseInfo(method, request, result);
            }
            this.logBenchmarkInfo(method, request, executionTime);
        });
        return future;
    }

    @Override
    public <T> T sendRequest(String method, AisHttpRequest request, TypeReference<T> responseType, long timeout, TimeUnit unit) throws AisHttpException {
        this.logRequestInfo(method, request);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(request.getRequestId());
        try {
            T result = this.delegate.sendRequest(method, request, responseType, timeout, unit);
            this.logResponseInfo(method, request, result);
            T t = result;
            return t;
        }
        catch (Exception ex) {
            this.logExceptionInfo(method, request, ex);
            throw ex;
        }
        finally {
            this.logBenchmarkInfo(method, request, stopWatch.stop());
        }
    }

    private void logRequestInfo(String method, AisHttpRequest request) {
        String requestBody = this.toJsonString(request.getBody());
        LOGGER.info("[{}] Sends request to >>> Method={}, path={}, requestBody={}", new Object[]{request.getRequestId(), method, request.getPath(), requestBody});
    }

    private void logResponseInfo(String method, AisHttpRequest request, Object result) {
        String responseBody = this.toJsonString(result);
        LOGGER.info("[{}] Received response from <<< method={}, path={}, responseBody={}", new Object[]{request.getRequestId(), method, request.getPath(), responseBody});
    }

    private void logBenchmarkInfo(String method, AisHttpRequest request, Long executionTime) {
        LOGGER.info("[{}] Request to method={}, path={} finished in {} ms.", new Object[]{request.getRequestId(), method, request.getPath(), executionTime});
    }

    private void logExceptionInfo(String method, AisHttpRequest request, Throwable ex) {
        LOGGER.error("[{}] An error occurred while communicating with method={}, path={}, Error={}.", new Object[]{request.getRequestId(), method, request.getPath(), ex.getMessage()});
    }

    private String toJsonString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception ex) {
            return "JSON serialization failed";
        }
    }
}

