/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.exception;

import java.util.StringJoiner;

public class AisHttpException
extends RuntimeException {
    private static final long serialVersionUID = -1193143672804622254L;
    private final ErrorType errorType;
    private final Integer statusCode;
    private final String responseBody;

    public AisHttpException(ErrorType errorType, String message, Integer statusCode, String responseBody) {
        super(AisHttpException.createMessage(errorType, message, statusCode, responseBody));
        this.errorType = errorType;
        this.statusCode = statusCode;
        this.responseBody = responseBody;
    }

    public AisHttpException(ErrorType errorType, String message, Integer statusCode, String responseBody, Throwable cause) {
        this(errorType, message, statusCode, responseBody);
        this.initCause(cause);
    }

    public AisHttpException(ErrorType errorType, String message, Throwable cause) {
        super(AisHttpException.createMessage(errorType, message));
        this.errorType = errorType;
        this.statusCode = null;
        this.responseBody = null;
        this.initCause(cause);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    private static String createMessage(ErrorType errorType, String message, Integer statusCode, String responseBody) {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        joiner.add(String.format("errorType=%s", new Object[]{errorType}));
        joiner.add(String.format("message=%s", message));
        joiner.add(String.format("statusCode=%03d", statusCode));
        joiner.add(String.format("responseBody=%s", responseBody));
        return joiner.toString();
    }

    private static String createMessage(ErrorType errorType, String message) {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        joiner.add(String.format("errorType=%s", new Object[]{errorType}));
        joiner.add(String.format("message=%s", message));
        return joiner.toString();
    }

    public static enum ErrorType {
        HTTP_STATUS_CODE_ERROR,
        MALFORMED_RESPONSE_ERROR,
        CONNECTION_ERROR,
        OTHERS;

    }
}

