/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.apache;

import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestExecutor;

public final class DefaultHttpRequestExecutor
implements HttpRequestExecutor<HttpUriRequest, HttpResponse> {
    private final CloseableHttpAsyncClient httpAsyncClient;

    public DefaultHttpRequestExecutor(CloseableHttpAsyncClient httpAsyncClient) {
        this.httpAsyncClient = httpAsyncClient;
    }

    @Override
    public CompletableFuture<HttpResponse> execute(HttpUriRequest request) {
        final CompletableFuture<HttpResponse> futureResponse = new CompletableFuture<HttpResponse>();
        this.httpAsyncClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                futureResponse.complete(result);
            }

            public void failed(Exception ex) {
                futureResponse.completeExceptionally(ex);
            }

            public void cancelled() {
                futureResponse.completeExceptionally(new RuntimeException("Request was cancelled."));
            }
        });
        return futureResponse;
    }
}

