/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.token;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import uk.ac.warwick.util.ais.auth.token.AccessToken;

public final class TokenCache {
    private static final int TOKEN_EXPIRY_THRESHOLD = 300;
    private final Map<String, AccessToken> cache = new LinkedHashMap<String, AccessToken>();
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken getAccessToken(String key, Supplier<AccessToken> tokenSupplier) {
        this.lock.lock();
        try {
            AccessToken token = this.cache.get(key);
            if (token == null || this.isExpiringSoon(token)) {
                token = tokenSupplier.get();
                this.cache.put(key, token);
            }
            AccessToken accessToken = token;
            return accessToken;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isExpiringSoon(AccessToken token) {
        Instant threshold = Instant.now().plusSeconds(300L);
        return token.getExpiryTime().isBefore(threshold);
    }
}

