/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import uk.ac.warwick.util.ais.auth.exception.TokenFetchException;
import uk.ac.warwick.util.ais.auth.model.OAuth2TokenFetchParameters;
import uk.ac.warwick.util.ais.auth.token.AccessToken;

public final class DefaultOAuth2TokenFetcher
implements Function<OAuth2TokenFetchParameters, AccessToken> {
    private static final int NON_STANDARD_HTTP_STATUS_CODE = -1;
    private final ObjectMapper objectMapper;
    private final Function<HttpUriRequest, CompletableFuture<HttpResponse>> requestExecutor;

    public DefaultOAuth2TokenFetcher(ObjectMapper objectMapper, Function<HttpUriRequest, CompletableFuture<HttpResponse>> requestExecutor) {
        this.objectMapper = objectMapper;
        this.requestExecutor = requestExecutor;
    }

    @Override
    public AccessToken apply(OAuth2TokenFetchParameters parameters) {
        HttpUriRequest accessTokenRequest = this.createAccessTokenRequest(parameters);
        return this.sendRequest(accessTokenRequest);
    }

    private AccessToken sendRequest(HttpUriRequest request) {
        try {
            HttpResponse response = this.requestExecutor.apply(request).get(30L, TimeUnit.SECONDS);
            return this.handleResponse(response);
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (ex instanceof ExecutionException) {
                cause = ex.getCause();
            }
            throw new TokenFetchException(String.format("An error occurred while fetching access token from the Authorization Server: %s.", cause.getMessage()), -1, null, cause);
        }
    }

    private AccessToken handleResponse(HttpResponse httpResponse) throws IOException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
        String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        if (statusCode != 200) {
            throw new TokenFetchException(String.format("Failed to acquire access token from the Authorization Server: %d - %s.", statusCode, reasonPhrase), statusCode, responseBody);
        }
        return (AccessToken)this.objectMapper.readValue(responseBody, AccessToken.class);
    }

    private HttpUriRequest createAccessTokenRequest(OAuth2TokenFetchParameters parameters) {
        return RequestBuilder.post((String)parameters.getAuthority()).setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_FORM_URLENCODED).setParameters(new NameValuePair[]{new BasicNameValuePair("grant_type", parameters.getGrantType()), new BasicNameValuePair("client_id", parameters.getClientId()), new BasicNameValuePair("client_secret", parameters.getClientSecret()), new BasicNameValuePair("scope", parameters.getScope())}).build()).build();
    }
}

