/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.model;

import java.util.HashSet;
import java.util.Set;

public class ClientCredentialsRequest {
    private final String scope;
    private final Boolean skipCache;

    public ClientCredentialsRequest(String scope, Boolean skipCache) {
        this.scope = scope;
        this.skipCache = skipCache;
    }

    private ClientCredentialsRequest(Builder builder) {
        this.scope = String.join((CharSequence)builder.scopeSeparator, builder.scopes);
        this.skipCache = builder.skipCache;
    }

    public String getScope() {
        return this.scope;
    }

    public Boolean getSkipCache() {
        return this.skipCache;
    }

    public static class Builder {
        private Set<String> scopes = new HashSet<String>();
        private Boolean skipCache = false;
        private String scopeSeparator = " ";

        public Builder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder addScope(String scope) {
            this.scopes.add(scope);
            return this;
        }

        public Builder skipCache(Boolean skipCache) {
            this.skipCache = skipCache;
            return this;
        }

        public Builder scopeSeparator(String scopeSeparator) {
            this.scopeSeparator = scopeSeparator;
            return this;
        }

        public ClientCredentialsRequest build() {
            if (this.scopes == null || this.scopes.isEmpty()) {
                throw new IllegalArgumentException("scopes cannot be null or empty.");
            }
            return new ClientCredentialsRequest(this);
        }
    }
}

