/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth;

import java.util.function.Function;
import uk.ac.warwick.util.ais.auth.Authenticator;
import uk.ac.warwick.util.ais.auth.credentials.OAuth2ClientCredentials;
import uk.ac.warwick.util.ais.auth.exception.AuthenticationException;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsRequest;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsResult;
import uk.ac.warwick.util.ais.auth.model.OAuth2TokenFetchParameters;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.auth.token.TokenCache;

public class OAuth2ClientCredentialsAuthenticator
implements Authenticator<ClientCredentialsRequest, ClientCredentialsResult> {
    private static final String SHARP = "#";
    private final OAuth2ClientCredentials credentials;
    private final Function<OAuth2TokenFetchParameters, AccessToken> tokenFetcher;
    private final TokenCache tokenCache;

    public OAuth2ClientCredentialsAuthenticator(OAuth2ClientCredentials credentials, Function<OAuth2TokenFetchParameters, AccessToken> tokenFetcher, TokenCache tokenCache) {
        this.credentials = credentials;
        this.tokenFetcher = tokenFetcher;
        this.tokenCache = tokenCache;
    }

    @Override
    public ClientCredentialsResult authenticate(ClientCredentialsRequest request) throws AuthenticationException {
        try {
            if (request.getSkipCache() == Boolean.FALSE) {
                String key = this.credentials.getClientId() + SHARP + request.getScope();
                AccessToken cachedToken = this.tokenCache.getAccessToken(key, () -> this.fetchToken(request));
                return new ClientCredentialsResult(request.getScope(), cachedToken);
            }
            AccessToken accessToken = this.fetchToken(request);
            return new ClientCredentialsResult(request.getScope(), accessToken);
        }
        catch (Exception e) {
            throw new AuthenticationException("Failed to authenticate with the Authorization Server.", e);
        }
    }

    private AccessToken fetchToken(ClientCredentialsRequest request) {
        OAuth2TokenFetchParameters parameters = new OAuth2TokenFetchParameters(this.credentials, request.getScope());
        return this.tokenFetcher.apply(parameters);
    }
}

