/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import uk.ac.warwick.util.ais.apim.rodb.RodbHttpClient;
import uk.ac.warwick.util.ais.apim.rodb.RodbHttpClientImpl;
import uk.ac.warwick.util.ais.apim.stutalk.StuTalkHttpClient;
import uk.ac.warwick.util.ais.apim.stutalk.StuTalkHttpClientImpl;
import uk.ac.warwick.util.ais.apim.stutalk.json.StuTalkJsonConverterImpl;
import uk.ac.warwick.util.ais.auth.Authenticator;
import uk.ac.warwick.util.ais.auth.OAuth2ClientCredentialsAuthenticator;
import uk.ac.warwick.util.ais.auth.credentials.OAuth2ClientCredentials;
import uk.ac.warwick.util.ais.auth.exception.TokenFetchException;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsRequest;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsResult;
import uk.ac.warwick.util.ais.auth.model.OAuth2TokenFetchParameters;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.auth.token.DefaultOAuth2TokenFetcher;
import uk.ac.warwick.util.ais.auth.token.TokenCache;
import uk.ac.warwick.util.ais.core.apache.DefaultAisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.apache.DefaultHttpRequestBuilder;
import uk.ac.warwick.util.ais.core.apache.DefaultHttpRequestExecutor;
import uk.ac.warwick.util.ais.core.helpers.AisHttpRequestAuthorizer;
import uk.ac.warwick.util.ais.core.helpers.AisHttpRequestLogger;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClientBase;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestExecutor;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;
import uk.ac.warwick.util.ais.core.json.PipelineStringDeserializer;
import uk.ac.warwick.util.ais.core.json.PipelineStringSerializer;
import uk.ac.warwick.util.ais.core.json.TransformerPipelineFactory;
import uk.ac.warwick.util.ais.core.properties.AisApimProperties;
import uk.ac.warwick.util.ais.core.resilience.ResilienceConfig;
import uk.ac.warwick.util.ais.core.resilience.ResilienceDecorators;

@Configuration
public class AisSpringConfiguration {
    private static final int CONNECT_TIME_OUT = 5000;
    private static final int SOCKET_TIME_OUT = 60000;
    private static final int CONNECTION_REQUEST_TIME_OUT = 5000;
    private static final String YYYY_MM_DD_DATE_PATTERN = "yyyy-MM-dd";
    private static final Set<Integer> RETRIABLE_STATUS_CODE = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(500, 502, 503, 504)));

    @Bean(name={"aisApacheHttpAsyncClient"})
    public CloseableHttpAsyncClient httpAsyncClient(@Value(value="${ais.apim.http.maxConnections:10}") Integer maxConnections) {
        CloseableHttpAsyncClient httpAsyncClient = HttpAsyncClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(5000).build()).setMaxConnPerRoute(maxConnections.intValue()).setMaxConnTotal(2 * maxConnections).build();
        httpAsyncClient.start();
        return httpAsyncClient;
    }

    @Bean(name={"stuTalkObjectMapper"})
    public ObjectMapper stuTalkObjectMapper(@Value(value="${ais.apim.objectMapper.emptyStringToNull:true}") boolean emptyStringToNull, @Value(value="${ais.apim.objectMapper.normaliseNewline:false}") boolean normaliseNewline) {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new DefaultScalaModule()).registerModule((Module)new JodaModule()).registerModule(this.buildCustomStutalkModule(emptyStringToNull, normaliseNewline)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).setDateFormat((DateFormat)new SimpleDateFormat(YYYY_MM_DD_DATE_PATTERN));
    }

    private Module buildCustomStutalkModule(boolean shouldConvertEmptyStringsToNull, boolean shouldNormalizeNewlines) {
        SimpleModule stutalkModule = new SimpleModule();
        stutalkModule.addSerializer(String.class, (JsonSerializer)new PipelineStringSerializer(TransformerPipelineFactory.createSerializer(shouldNormalizeNewlines)));
        stutalkModule.addDeserializer(String.class, (JsonDeserializer)new PipelineStringDeserializer(TransformerPipelineFactory.createDeserializer(shouldConvertEmptyStringsToNull, shouldNormalizeNewlines)));
        return stutalkModule;
    }

    @Bean(name={"stuTalkJsonConverter"})
    public AisJsonConverter stuTalkJsonConverter(@Qualifier(value="stuTalkObjectMapper") ObjectMapper objectMapper) {
        return new StuTalkJsonConverterImpl(objectMapper);
    }

    @Bean(name={"aisHttpResponseHandler"})
    public AisHttpResponseHandler<HttpResponse> aisHttpResponseHandler(@Qualifier(value="stuTalkJsonConverter") AisJsonConverter stuTalkJsonConverter) {
        return new DefaultAisHttpResponseHandler(stuTalkJsonConverter);
    }

    @Bean(name={"aisHttpRequestExecutor"})
    public HttpRequestExecutor<HttpUriRequest, HttpResponse> aisHttpRequestExecutor(@Qualifier(value="aisApacheHttpAsyncClient") CloseableHttpAsyncClient httpAsyncClient) {
        return new DefaultHttpRequestExecutor(httpAsyncClient);
    }

    @Bean(name={"aisOAuth2ClientCredentials"})
    public OAuth2ClientCredentials aisOAuth2ClientCredentials(@Value(value="${ais.apim.auth.oauth2.auth_url:}") String authority, @Value(value="${ais.apim.auth.oauth2.client_id:}") String clientId, @Value(value="${ais.apim.auth.oauth2.client_secret:}") String clientSecret) {
        return new OAuth2ClientCredentials(authority, clientId, clientSecret);
    }

    @Bean(name={"aisAuthTokenCache"})
    public TokenCache aisAuthTokenCache() {
        return new TokenCache();
    }

    @Bean(name={"aisAuthTokenFetcher"})
    public Function<OAuth2TokenFetchParameters, AccessToken> aisAuthTokenFetcher(@Qualifier(value="stuTalkObjectMapper") ObjectMapper objectMapper, @Qualifier(value="aisHttpRequestExecutor") HttpRequestExecutor<HttpUriRequest, HttpResponse> httpRequestExecutor) {
        return ResilienceDecorators.ofFunction(new DefaultOAuth2TokenFetcher(objectMapper, httpRequestExecutor::execute)).withCircuitBreaker(ResilienceConfig.createCircuitBreaker("aisAuthCircuitBreaker")).withRetry(ResilienceConfig.createRetry("aisAuthRetry", this::isRetriable)).decorate();
    }

    @Bean(name={"aisAuthenticator"})
    public Authenticator<ClientCredentialsRequest, ClientCredentialsResult> aisAuthenticator(@Qualifier(value="aisOAuth2ClientCredentials") OAuth2ClientCredentials credentials, @Qualifier(value="aisAuthTokenFetcher") Function<OAuth2TokenFetchParameters, AccessToken> tokenFetcher, @Qualifier(value="aisAuthTokenCache") TokenCache tokenCache) {
        return new OAuth2ClientCredentialsAuthenticator(credentials, tokenFetcher, tokenCache);
    }

    @Bean(name={"aisApimProperties"})
    public AisApimProperties aisApimProperties(final @Value(value="${ais.apim.headers.bapi-channel-id}") String bapiChannelId, final @Value(value="${ais.apim.headers.bapi-app-id}") String bapiAppId, final @Value(value="${ais.apim.base-url}") String baseUrl) {
        return new AisApimProperties(){

            @Override
            public String getBapiChannelId() {
                return bapiChannelId;
            }

            @Override
            public String getBapiAppId() {
                return bapiAppId;
            }

            @Override
            public String getBaseUrl() {
                return baseUrl;
            }
        };
    }

    @Bean(name={"aisHttpRequestBuilder"})
    public HttpRequestBuilder<HttpUriRequest> aisHttpRequestBuilder(@Qualifier(value="stuTalkJsonConverter") AisJsonConverter jsonConverter, @Qualifier(value="aisApimProperties") AisApimProperties aisApimProperties) {
        return new DefaultHttpRequestBuilder(jsonConverter, aisApimProperties);
    }

    @Bean(name={"aisAuthHttpRequestBuilder"})
    public HttpRequestBuilder<HttpUriRequest> aisAuthHttpRequestBuilder(@Value(value="${ais.apim.auth.oauth2.scope:}") String defaultScope, @Qualifier(value="aisAuthenticator") Authenticator<ClientCredentialsRequest, ClientCredentialsResult> authenticator, @Qualifier(value="aisHttpRequestBuilder") HttpRequestBuilder<HttpUriRequest> requestBuilder) {
        return new AisHttpRequestAuthorizer<HttpUriRequest>(defaultScope, authenticator, requestBuilder);
    }

    @Bean(name={"aisHttpAsyncClient"})
    public AisHttpAsyncClient aisHttpAsyncClient(@Qualifier(value="aisAuthHttpRequestBuilder") HttpRequestBuilder<HttpUriRequest> aisAuthHttpRequestBuilder, @Qualifier(value="aisHttpResponseHandler") AisHttpResponseHandler<HttpResponse> responseHandler, @Qualifier(value="aisHttpRequestExecutor") HttpRequestExecutor<HttpUriRequest, HttpResponse> httpRequestExecutor, @Qualifier(value="stuTalkObjectMapper") ObjectMapper objectMapper) {
        AisHttpAsyncClientBase<HttpUriRequest, HttpResponse> delegate = new AisHttpAsyncClientBase<HttpUriRequest, HttpResponse>(aisAuthHttpRequestBuilder, responseHandler, httpRequestExecutor);
        return new AisHttpRequestLogger(objectMapper, delegate);
    }

    @Bean(name={"stuTalkHttpClient"})
    public StuTalkHttpClient stuTalkHttpClient(@Qualifier(value="aisHttpAsyncClient") AisHttpAsyncClient aisHttpAsyncClient) {
        return new StuTalkHttpClientImpl(aisHttpAsyncClient);
    }

    @Bean(name={"rodbHttpClient"})
    public RodbHttpClient rodbHttpClient(@Qualifier(value="aisHttpAsyncClient") AisHttpAsyncClient aisHttpAsyncClient) {
        return new RodbHttpClientImpl(aisHttpAsyncClient);
    }

    private boolean isRetriable(Throwable ex) {
        if (!(ex instanceof TokenFetchException)) {
            return false;
        }
        TokenFetchException tokenEx = (TokenFetchException)ex;
        int statusCode = tokenEx.getStatusCode();
        Throwable cause = tokenEx.getCause();
        return RETRIABLE_STATUS_CODE.contains(statusCode) || cause instanceof SocketException || cause instanceof SocketTimeoutException || cause instanceof TimeoutException;
    }
}

