/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.core.json.NewlineSerializerTransformer;
import uk.ac.warwick.util.ais.core.json.PipelineStringSerializer;
import uk.ac.warwick.util.ais.core.json.StringTransformer;

public class NormaliseNewLineSerializerTest {
    private final NewlineSerializerTransformer transformer = new NewlineSerializerTransformer();
    private final PipelineStringSerializer serializer = new PipelineStringSerializer((StringTransformer)this.transformer);
    private final JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
    private final SerializerProvider serializerProvider = (SerializerProvider)Mockito.mock(SerializerProvider.class);

    @Test
    public void serialize_WithMixedNewlines_returnOnlyUnixStyle() throws IOException {
        String input = "Line1\r\nLine2\nLine3\r\n";
        String expected = "Line1\nLine2\nLine3\n";
        this.serializer.serialize(input, this.jsonGenerator, this.serializerProvider);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeString(expected);
    }

    @Test
    public void serialize_EmptyString_returnSameValue() throws IOException {
        String input = "";
        this.serializer.serialize(input, this.jsonGenerator, this.serializerProvider);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeString(input);
    }

    @Test
    public void serialize_NoNewlines_returnSameValue() throws IOException {
        String input = "NoNewlinesHere";
        this.serializer.serialize(input, this.jsonGenerator, this.serializerProvider);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeString(input);
    }
}

