/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.helpers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.core.helpers.AisHttpRequestLogger;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

public class AisHttpRequestLoggerTest {
    private static final String GET_METHOD = "GET";
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void sendRequestAsync_successful() throws Exception {
        AisHttpRequest request = new AisHttpRequest.Builder().path("path").body((Object)"body").build();
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.complete("response");
        AisHttpAsyncClient delegate = (AisHttpAsyncClient)Mockito.mock(AisHttpAsyncClient.class);
        Mockito.when((Object)delegate.sendRequestAsync((String)Matchers.eq((Object)GET_METHOD), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class))).thenReturn(future);
        AisHttpRequestLogger aisHttpRequestLogger = new AisHttpRequestLogger(this.objectMapper, delegate);
        CompletableFuture resultFuture = aisHttpRequestLogger.sendRequestAsync(GET_METHOD, request, (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals((Object)"response", resultFuture.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void sendRequestAsync_exception() {
        AisHttpRequest request = new AisHttpRequest.Builder().path("path").body((Object)"body").build();
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new RuntimeException("Exception"));
        AisHttpAsyncClient delegate = (AisHttpAsyncClient)Mockito.mock(AisHttpAsyncClient.class);
        Mockito.when((Object)delegate.sendRequestAsync((String)Matchers.eq((Object)GET_METHOD), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class))).thenReturn(future);
        AisHttpRequestLogger aisHttpRequestLogger = new AisHttpRequestLogger(this.objectMapper, delegate);
        CompletableFuture resultFuture = aisHttpRequestLogger.sendRequestAsync(GET_METHOD, request, (TypeReference)new TypeReference<String>(){});
        try {
            resultFuture.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RuntimeException));
            Assert.assertEquals((Object)"Exception", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void sendRequest_successful() throws Exception {
        AisHttpRequest request = new AisHttpRequest.Builder().path("path").body((Object)"body").build();
        AisHttpAsyncClient delegate = (AisHttpAsyncClient)Mockito.mock(AisHttpAsyncClient.class);
        Mockito.when((Object)delegate.sendRequest((String)Matchers.eq((Object)GET_METHOD), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class), Matchers.eq((long)1L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))))).thenReturn((Object)"response");
        AisHttpRequestLogger aisHttpRequestLogger = new AisHttpRequestLogger(this.objectMapper, delegate);
        String result = (String)aisHttpRequestLogger.sendRequest(GET_METHOD, request, (TypeReference)new TypeReference<String>(){}, 1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"response", (Object)result);
    }

    @Test
    public void sendRequest_exception() {
        AisHttpRequest request = new AisHttpRequest.Builder().path("path").body((Object)"body").build();
        AisHttpAsyncClient delegate = (AisHttpAsyncClient)Mockito.mock(AisHttpAsyncClient.class);
        Mockito.when((Object)delegate.sendRequest((String)Matchers.eq((Object)GET_METHOD), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class), Matchers.eq((long)1L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))))).thenThrow(new Throwable[]{new RuntimeException("Exception")});
        AisHttpRequestLogger aisHttpRequestLogger = new AisHttpRequestLogger(this.objectMapper, delegate);
        try {
            aisHttpRequestLogger.sendRequest(GET_METHOD, request, (TypeReference)new TypeReference<String>(){}, 1L, TimeUnit.SECONDS);
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof RuntimeException));
            Assert.assertEquals((Object)"Exception", (Object)e.getMessage());
        }
    }
}

