/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.token;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.auth.token.TokenCache;

public class TokenCacheTest {
    @Test
    public void getAccessToken_noCachedToken_returnsSuppliedToken() {
        TokenCache tokenCache = new TokenCache();
        AccessToken token = new AccessToken("token", "Bearer", Long.valueOf(3600L));
        AccessToken result = tokenCache.getAccessToken("scope", () -> token);
        Assert.assertEquals((Object)token, (Object)result);
    }

    @Test
    public void getAccessToken_expiringToken_fetchesNewToken() {
        TokenCache tokenCache = new TokenCache();
        AccessToken expiringToken = new AccessToken("expiringToken", "Bearer", Long.valueOf(60L));
        AccessToken newToken = new AccessToken("newToken", "Bearer", Long.valueOf(3600L));
        tokenCache.getAccessToken("scope", () -> expiringToken);
        AccessToken result = tokenCache.getAccessToken("scope", () -> newToken);
        Assert.assertEquals((Object)newToken, (Object)result);
    }

    @Test
    public void getAccessToken_nonExpiringToken_returnsCachedToken() {
        TokenCache tokenCache = new TokenCache();
        AccessToken cachedToken = new AccessToken("expiringToken", "Bearer", Long.valueOf(3600L));
        AccessToken newToken = new AccessToken("token", "Bearer", Long.valueOf(3600L));
        tokenCache.getAccessToken("scope", () -> cachedToken);
        AccessToken result = tokenCache.getAccessToken("scope", () -> newToken);
        Assert.assertEquals((Object)cachedToken, (Object)result);
    }

    @Test
    public void getAccessToken_whenConcurrentRequest_fetchOnlyOnce() throws InterruptedException {
        TokenCache tokenCache = new TokenCache();
        AccessToken newToken = new AccessToken("token", "Bearer", Long.valueOf(3600L));
        AtomicInteger count = new AtomicInteger();
        Supplier<AccessToken> tokenSupplier = () -> {
            count.getAndIncrement();
            return newToken;
        };
        Thread thread1 = new Thread(() -> tokenCache.getAccessToken("scope", tokenSupplier));
        Thread thread2 = new Thread(() -> tokenCache.getAccessToken("scope", tokenSupplier));
        Thread thread3 = new Thread(() -> tokenCache.getAccessToken("scope", tokenSupplier));
        thread1.start();
        thread2.start();
        thread3.start();
        thread1.join();
        thread2.join();
        thread3.join();
        Assert.assertEquals((long)1L, (long)count.get());
    }
}

