/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim.stutalk;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.apim.stutalk.StuTalkHttpRequestBuilder;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.collections.Pair;

public class StuTalkHttpRequestBuilderTest {
    @Test(expected=IllegalArgumentException.class)
    public void build_apiCodeIsNull_throwException() {
        new StuTalkHttpRequestBuilder().correlationId("correlationId").body((Object)"body").build();
    }

    @Test
    public void build_getRequest_success() {
        StuTalkHttpRequestBuilder builder = new StuTalkHttpRequestBuilder().correlationId("correlationId").apiCode("apiCode").addPathVariable("key", "value").addPathVariable("key2", "value/2");
        AisHttpRequest request = builder.build();
        Assert.assertEquals((Object)"correlationId", (Object)request.getCorrelationId());
        Assert.assertNotNull((Object)request.getRequestId());
        Assert.assertNull((Object)request.getBody());
        Assert.assertEquals((Object)"apiCode/key/value/key2/value@@2", (Object)request.getPath());
        Assert.assertEquals((long)0L, (long)request.getQueryParams().size());
        Assert.assertEquals((long)0L, (long)request.getHeaders().size());
    }

    @Test
    public void build_postRequest_success() {
        StuTalkHttpRequestBuilder builder = new StuTalkHttpRequestBuilder().apiCode("apiCode").body((Object)"body");
        AisHttpRequest request = builder.build();
        Assert.assertNotNull((Object)request.getRequestId());
        Assert.assertEquals((Object)request.getRequestId(), (Object)request.getCorrelationId());
        Assert.assertEquals((Object)"body", (Object)request.getBody());
        Assert.assertEquals((Object)"apiCode", (Object)request.getPath());
        Assert.assertEquals((long)0L, (long)request.getQueryParams().size());
        Assert.assertEquals((long)0L, (long)request.getHeaders().size());
    }

    @Test
    public void build_withQueryParamAndHeader_success() {
        StuTalkHttpRequestBuilder builder = new StuTalkHttpRequestBuilder().apiCode("apiCode").addPathVariable("key", "value/1/test").addQueryParam("query-1", "param-1").addQueryParam("query-2", "param-2").addHeader(new Pair((Object)"header-1", (Object)"header-1-value")).addHeader(new Pair((Object)"header-2", (Object)"header-2-value"));
        AisHttpRequest request = builder.build();
        Assert.assertNotNull((Object)request.getRequestId());
        Assert.assertEquals((Object)request.getRequestId(), (Object)request.getCorrelationId());
        Assert.assertNull((Object)request.getBody());
        Assert.assertEquals((Object)"apiCode/key/value@@1@@test", (Object)request.getPath());
        Assert.assertEquals((long)2L, (long)request.getQueryParams().size());
        Assert.assertEquals((Object)"query-1", (Object)((Pair)request.getQueryParams().get(0)).getLeft());
        Assert.assertEquals((Object)"param-1", (Object)((Pair)request.getQueryParams().get(0)).getRight());
        Assert.assertEquals((Object)"query-2", (Object)((Pair)request.getQueryParams().get(1)).getLeft());
        Assert.assertEquals((Object)"param-2", (Object)((Pair)request.getQueryParams().get(1)).getRight());
        Assert.assertEquals((long)2L, (long)request.getHeaders().size());
        Assert.assertEquals((Object)"header-1", (Object)((Pair)request.getHeaders().get(0)).getLeft());
        Assert.assertEquals((Object)"header-1-value", (Object)((Pair)request.getHeaders().get(0)).getRight());
        Assert.assertEquals((Object)"header-2", (Object)((Pair)request.getHeaders().get(1)).getLeft());
        Assert.assertEquals((Object)"header-2-value", (Object)((Pair)request.getHeaders().get(1)).getRight());
    }
}

