/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.apim.AbstractAisHttpClientTemplate;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

public class AbstractAisHttpClientTemplateTest {
    private AisHttpAsyncClient httpAsyncClient;
    private AbstractAisHttpClientTemplate httpClient;

    @Before
    public void setUp() {
        this.httpAsyncClient = (AisHttpAsyncClient)Mockito.mock(AisHttpAsyncClient.class);
        this.httpClient = new AbstractAisHttpClientTemplate(this.httpAsyncClient){};
    }

    @Test
    public void getAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        Mockito.when((Object)this.httpAsyncClient.sendRequestAsync((String)Matchers.eq((Object)"GET"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class))).thenReturn(future);
        CompletableFuture result = this.httpClient.getAsync((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals(future, (Object)result);
    }

    @Test
    public void postAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        Mockito.when((Object)this.httpAsyncClient.sendRequestAsync((String)Matchers.eq((Object)"POST"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class))).thenReturn(future);
        CompletableFuture result = this.httpClient.postAsync((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals(future, (Object)result);
    }

    @Test
    public void putAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        Mockito.when((Object)this.httpAsyncClient.sendRequestAsync((String)Matchers.eq((Object)"PUT"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class))).thenReturn(future);
        CompletableFuture result = this.httpClient.putAsync((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals(future, (Object)result);
    }

    @Test
    public void deleteAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        Mockito.when((Object)this.httpAsyncClient.sendRequestAsync((String)Matchers.eq((Object)"DELETE"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class))).thenReturn(future);
        CompletableFuture result = this.httpClient.deleteAsync((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals(future, (Object)result);
    }

    @Test
    public void get_success() {
        Mockito.when((Object)this.httpAsyncClient.sendRequest((String)Matchers.eq((Object)"GET"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class), Matchers.eq((long)60L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))))).thenReturn((Object)"test");
        String result = (String)this.httpClient.get((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void post_success() {
        Mockito.when((Object)this.httpAsyncClient.sendRequest((String)Matchers.eq((Object)"POST"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class), Matchers.eq((long)60L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))))).thenReturn((Object)"test");
        String result = (String)this.httpClient.post((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void put_success() {
        Mockito.when((Object)this.httpAsyncClient.sendRequest((String)Matchers.eq((Object)"PUT"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class), Matchers.eq((long)60L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))))).thenReturn((Object)"test");
        String result = (String)this.httpClient.put((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void delete_success() {
        Mockito.when((Object)this.httpAsyncClient.sendRequest((String)Matchers.eq((Object)"DELETE"), (AisHttpRequest)Matchers.any(AisHttpRequest.class), (TypeReference)Matchers.any(TypeReference.class), Matchers.eq((long)60L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))))).thenReturn((Object)"test");
        String result = (String)this.httpClient.delete((AisHttpRequest)Mockito.mock(AisHttpRequest.class), (TypeReference)new TypeReference<String>(){});
        Assert.assertEquals((Object)"test", (Object)result);
    }
}

