package uk.ac.warwick.util.ais.core.utils;

import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class StuTalkEncodeUtilsTest {

    @Test
    public void startsWith_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.startsWith("5553778");
        assertEquals("5553778<GOLD>*", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void startsWith_nullValue_throwsException() {
        StuTalkEncodeUtils.startsWith(null);
    }

    @Test
    public void greaterThanOrEqualTo_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.greaterThanOrEqualTo("5553778");
        assertEquals("<GOLD>GE5553778", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void greaterThanOrEqualTo_nullValue_throwsException() {
        StuTalkEncodeUtils.greaterThanOrEqualTo(null);
    }

    @Test
    public void greaterThan_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.greaterThan("5553778");
        assertEquals("<GOLD>G5553778", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void greaterThan_nullValue_throwsException() {
        StuTalkEncodeUtils.greaterThan(null);
    }

    @Test
    public void lessThanOrEqualTo_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.lessThanOrEqualTo("5553778");
        assertEquals("<GOLD>LE5553778", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void lessThanOrEqualTo_nullValue_throwsException() {
        StuTalkEncodeUtils.lessThanOrEqualTo(null);
    }

    @Test
    public void lessThan_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.lessThan("5553778");
        assertEquals("<GOLD>L5553778", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void lessThan_nullValue_throwsException() {
        StuTalkEncodeUtils.lessThan(null);
    }

    @Test
    public void notEqualTo_validValue_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.notEqualTo("5553778");
        assertEquals("<GOLD>NE5553778", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void notEqualTo_nullValue_throwsException() {
        StuTalkEncodeUtils.notEqualTo(null);
    }

    @Test
    public void isNull_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.isNull();
        assertEquals("<GOLD>NULL", result);
    }

    @Test
    public void isAny_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.isAny();
        assertEquals("<GOLD>*", result);
    }

    @Test
    public void either_validValues_returnsExpectedResult() {
        String result = StuTalkEncodeUtils.either("value1", "value2");
        assertEquals("value1<GOLD>|value2", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void either_nullFirstValue_throwsException() {
        StuTalkEncodeUtils.either(null, "value2");
    }

    @Test(expected = IllegalArgumentException.class)
    public void either_nullSecondValue_throwsException() {
        StuTalkEncodeUtils.either("value1", null);
    }

    @Test
    public void encode_validValue_encodesSlashCharacter() {
        String result = StuTalkEncodeUtils.encode("value/with/slash");
        assertEquals("value@@with@@slash", result);
    }

    @Test(expected = IllegalArgumentException.class)
    public void encode_nullValue_throwsException() {
        StuTalkEncodeUtils.encode(null);
    }

    @Test
    public void decode_validValue_decodesSlashCharacter() {
        String result = StuTalkEncodeUtils.decode("value@@with@@slash");
        assertEquals("value/with/slash", result);
    }

    @Test
    public void decode_nullValue_returnsNull() {
        assertNull(StuTalkEncodeUtils.decode(null));
    }

}
