package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.junit.Test;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import java.io.IOException;


public class NormaliseNewLineSerializerTest {

    private final NewlineSerializerTransformer transformer = new NewlineSerializerTransformer();
    private final PipelineStringSerializer serializer = new PipelineStringSerializer(transformer);
    private final JsonGenerator jsonGenerator = mock(JsonGenerator.class);
    private final SerializerProvider serializerProvider = mock(SerializerProvider.class);

    @Test
    public void serialize_WithMixedNewlines_returnOnlyUnixStyle() throws IOException {
        String input = "Line1\r\nLine2\nLine3\r\n";
        String expected = "Line1\nLine2\nLine3\n";

        serializer.serialize(input, jsonGenerator, serializerProvider);

        verify(jsonGenerator).writeString(expected);
    }

    @Test
    public void serialize_EmptyString_returnSameValue() throws IOException {
        String input = "";

        serializer.serialize(input, jsonGenerator, serializerProvider);

        verify(jsonGenerator).writeString(input);
    }

    @Test
    public void serialize_NoNewlines_returnSameValue() throws IOException {
        String input = "NoNewlinesHere";

        serializer.serialize(input, jsonGenerator, serializerProvider);

        verify(jsonGenerator).writeString(input);
    }
}
