package uk.ac.warwick.util.ais.apim.stutalk;

import com.fasterxml.jackson.annotation.JsonProperty;
import uk.ac.warwick.util.ais.apim.stutalk.json.StuTalkProperties;

@StuTalkProperties(values = {"EXCHANGE", "SRA", "SRA.CAMS"})
public class TestData {

    @JsonProperty("AYR_CODE.SRA.CAMS")
    private String ayrCode;

    @JsonProperty("MAV_OCCUR.SRA.CAMS")
    private String mavOccur;

    @JsonProperty("MOD_CODE.SRA.CAMS")
    private String modCode;

    @JsonProperty("PSL_CODE.SRA.CAMS")
    private String pslCode;

    @JsonProperty("SPR_CODE.SRA.CAMS")
    private String sprCode;

    @JsonProperty("SRA_RSEQ.SRA.CAMS")
    private String sraRseq;

    public TestData() {
    }

    public TestData(String ayrCode, String mavOccur, String modCode, String pslCode, String sprCode, String sraRseq) {
        this.ayrCode = ayrCode;
        this.mavOccur = mavOccur;
        this.modCode = modCode;
        this.pslCode = pslCode;
        this.sprCode = sprCode;
        this.sraRseq = sraRseq;
    }

    public String getAyrCode() {
        return ayrCode;
    }

    public String getMavOccur() {
        return mavOccur;
    }

    public String getModCode() {
        return modCode;
    }

    public String getPslCode() {
        return pslCode;
    }

    public String getSprCode() {
        return sprCode;
    }

    public String getSraRseq() {
        return sraRseq;
    }
}
