package uk.ac.warwick.util.ais.apim.rodb;

import com.fasterxml.jackson.core.type.TypeReference;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

import static org.mockito.Mockito.mock;

public class RodbHttpClientImplTest {

    private AisHttpAsyncClient httpAsyncClient;
    private RodbHttpClientImpl httpClient;

    @Before
    public void setUp() {
        httpAsyncClient = mock(AisHttpAsyncClient.class);
        httpClient = new RodbHttpClientImpl(httpAsyncClient);
    }

    @Test(expected = UnsupportedOperationException.class)
    public void putAsync_unsupported() {
        httpClient.putAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
    }

    @Test(expected = UnsupportedOperationException.class)
    public void deleteAsync_unsupported() {
        httpClient.deleteAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
    }

    @Test(expected = UnsupportedOperationException.class)
    public void put_unsupported() {
        httpClient.put(mock(AisHttpRequest.class), new TypeReference<String>() {});
    }

    @Test(expected = UnsupportedOperationException.class)
    public void delete_unsupported() {
        httpClient.delete(mock(AisHttpRequest.class), new TypeReference<String>() {});
    }
}
