package uk.ac.warwick.util.ais.apim;

import com.fasterxml.jackson.core.type.TypeReference;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;

import java.util.concurrent.CompletableFuture;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class AbstractAisHttpClientTemplateTest {

    private AisHttpAsyncClient httpAsyncClient;
    private AbstractAisHttpClientTemplate httpClient;

    @Before
    public void setUp() {
        httpAsyncClient = mock(AisHttpAsyncClient.class);
        httpClient = new AbstractAisHttpClientTemplate(httpAsyncClient){};
    }

    @Test
    public void getAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        when(httpAsyncClient.sendRequestAsync(
                eq(AbstractAisHttpClientTemplate.GET_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class))
        ).thenReturn(future);

        CompletableFuture<String> result = httpClient.getAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals(future, result);
    }

    @Test
    public void postAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        when(httpAsyncClient.sendRequestAsync(
                eq(AbstractAisHttpClientTemplate.POST_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class))
        ).thenReturn(future);

        CompletableFuture<String> result = httpClient.postAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals(future, result);
    }

    @Test
    public void putAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        when(httpAsyncClient.sendRequestAsync(
                eq(AbstractAisHttpClientTemplate.PUT_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class))
        ).thenReturn(future);

        CompletableFuture<String> result = httpClient.putAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals(future, result);
    }

    @Test
    public void deleteAsync_success() {
        CompletableFuture<String> future = CompletableFuture.completedFuture("test");
        when(httpAsyncClient.sendRequestAsync(
                eq(AbstractAisHttpClientTemplate.DELETE_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class))
        ).thenReturn(future);

        CompletableFuture<String> result = httpClient.deleteAsync(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals(future, result);
    }

    @Test
    public void get_success() {
        when(httpAsyncClient.sendRequest(
                eq(AbstractAisHttpClientTemplate.GET_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class),
                eq(60L),
                eq(java.util.concurrent.TimeUnit.SECONDS))
        ).thenReturn("test");

        String result = httpClient.get(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals("test", result);
    }

    @Test
    public void post_success() {
        when(httpAsyncClient.sendRequest(
                eq(AbstractAisHttpClientTemplate.POST_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class),
                eq(60L),
                eq(java.util.concurrent.TimeUnit.SECONDS))
        ).thenReturn("test");
        String result = httpClient.post(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals("test", result);
    }

    @Test
    public void put_success() {
        when(httpAsyncClient.sendRequest(
                eq(AbstractAisHttpClientTemplate.PUT_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class),
                eq(60L),
                eq(java.util.concurrent.TimeUnit.SECONDS))
        ).thenReturn("test");
        String result = httpClient.put(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals("test", result);
    }

    @Test
    public void delete_success() {
        when(httpAsyncClient.sendRequest(
                eq(AbstractAisHttpClientTemplate.DELETE_METHOD),
                any(AisHttpRequest.class),
                any(TypeReference.class),
                eq(60L),
                eq(java.util.concurrent.TimeUnit.SECONDS))
        ).thenReturn("test");
        String result = httpClient.delete(mock(AisHttpRequest.class), new TypeReference<String>() {});
        assertEquals("test", result);
    }
}
