package uk.ac.warwick.util.ais.core.json;

/**
 * A reusable {@link StringTransformer} that converts empty strings to {@code null}.
 *
 * <p>This transformer is typically used as part of a transformation pipeline to ensure
 * that empty strings (i.e., {@code ""}) are treated as {@code null}, which can be useful
 * for both serialization and deserialization logic depending on the context.</p>
 */
public class EmptyStringToNullTransformer implements StringTransformer {

    /**
     * Transforms the input string by converting empty strings to {@code null}.
     *
     * @param input the input string, possibly empty
     * @return {@code null} if input is an empty string; otherwise, returns the original input
     */
    @Override
    public String transform(String input) {
        if (input == null) return null;
        if (input.isEmpty()) return null;
        return input;
    }
}
