package uk.ac.warwick.util.ais.core.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.exception.AisJsonProcessingException;

public interface AisHttpResponseHandler<R> {

    /**
     * This method provides a way to mapping response to the expected result object.<br>
     * Please note that even if we receive an HTTP Response from the external service, it may contain one of the following errors:
     * <p>3xx, 4xx, 5xx Status Code Error: The request contains bad syntax or cannot be fulfilled.</p>
     * <p>2xx Malformed response: The service may return invalid response content (such as invalid JSON or unexpected content).</p>
     * Response data would be validated and parsed carefully, and provide fallback if there are errors.
     *
     * @param response      The http response
     * @param typeReference The type reference of type of result object
     * @return              The result object
     * @throws AisJsonProcessingException if an error occurs reading the input stream or invalid JSON or unexpected content.
     * @throws AisHttpException Any other error that can be classified as an HttpCommunicationException
     */
    <T> T handleResponse(R response, TypeReference<T> typeReference) throws AisHttpException;

    /**
     * Handle error occurred during the communication with AIS API Management Service.
     * They all should be classified and mapped to a generic AisHttpException
     *
     * @param ex The exception
     * @return A AisHttpException
     */
    AisHttpException handleError(Throwable ex);
}
