package uk.ac.warwick.util.ais.core.exception;

/**
 * This exception class was created to wrap up IOException that may occur while serialising/deserialising JSON.
 * It is intentionally inherited from RuntimeException
 * because Scala applications are not required to explicitly try/catch to handle Checked Exceptions.
 * and when Checked Exceptions are thrown (without try/catch) in a transactional scope it will not be rolled-back properly.
 * So throwing a RuntimeException (Unchecked exception) will ensure the rollback is executed.
 * And the error will then need to be analysed and handled.
 */
public class AisJsonProcessingException extends RuntimeException {

    private static final long serialVersionUID = 3408395739593509054L;

    public AisJsonProcessingException(String s, Throwable throwable) {
        super(s, throwable);
    }
}
