package uk.ac.warwick.util.ais.auth.exception;

/**
 * Exception thrown when the access token cannot be fetched from the Authorization Server.
 * It contains the HTTP status code and the response body (if available).
 * By default, resilience4j considers unhandled exceptions as failures, so this should inherit from RuntimeException.
 *
 */
public class TokenFetchException extends RuntimeException {

    private static final long serialVersionUID = 8422649075819850142L;
    private final Integer statusCode;
    private final String responseBody;

    /**
     * Create a token fetch exception from a known exception.
     *
     *  @param message      The error message
     *  @param statusCode   The HTTP status code
     *  @param responseBody The response body (if available)
     *  @param cause The throwable cause that cause the exception
     */
    public TokenFetchException(String message,
                               Integer statusCode,
                               String responseBody,
                               Throwable cause) {
        super(message);
        this.statusCode = statusCode;
        this.responseBody = responseBody;
        initCause(cause);
    }

    /**
     *  Create a token fetch exception.
     *
     *  @param message      The error message
     *  @param statusCode   The HTTP status code
     *  @param responseBody The response body (if available)
     */
    public TokenFetchException(String message, Integer statusCode, String responseBody) {
        super(message);
        this.statusCode = statusCode;
        this.responseBody = responseBody;
    }

    public Integer getStatusCode() {
        return statusCode;
    }

    public String getResponseBody() {
        return responseBody;
    }
}
