package uk.ac.warwick.util.ais.auth.credentials;

public final class OAuth2ClientCredentials implements Credentials {

    private final String authority;
    private final String clientId;
    private final String clientSecret;

    public OAuth2ClientCredentials(String authServerUrl,
                                   String clientId,
                                   String clientSecret) {
        this.authority = authServerUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public String getAuthority() {
        return authority;
    }

    public String getClientId() {
        return clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }
}
