package uk.ac.warwick.util.ais.apim.rodb.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

public class RodbResponse<T> {
    @JsonProperty("pagination")
    private RodbPagination pagination;

    @JsonProperty("data")
    private List<T> data;

    public RodbResponse() {
    }

    public RodbResponse(RodbPagination pagination, List<T> data) {
        this.pagination = pagination;
        this.data = data;
    }

    public RodbPagination getPagination() {
        return pagination;
    }

    public List<T> getData() {
        return data;
    }

    public boolean hasNextPage() { return pagination.getCurrentPage() < pagination.getTotalPages(); }
}
