/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.resilience;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.function.Predicate;

public final class ResilienceConfig {
    private static final float CB_FAILURE_RATE_THRESHOLD = 50.0f;
    private static final long CB_OPEN_STATE_DURATION = 60L;
    private static final int CB_SLIDING_WINDOW_SIZE = 10;
    private static final int CB_HALF_OPEN_STATE_PERMITTED_CALLS = 2;
    private static final int RETRY_MAX_ATTEMPTS = 3;
    private static final long RETRY_WAITING_INTERVAL = 5000L;
    private static final double RETRY_WAITING_INTERVAL_MULTIPLIER = 2.0;

    private ResilienceConfig() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }

    public static CircuitBreaker createCircuitBreaker(String name) {
        CircuitBreakerConfig config = CircuitBreakerConfig.custom().failureRateThreshold(50.0f).waitDurationInOpenState(Duration.ofSeconds(60L)).permittedNumberOfCallsInHalfOpenState(2).slidingWindowSize(10).build();
        return ResilienceConfig.createCircuitBreaker(name, config);
    }

    public static CircuitBreaker createCircuitBreaker(String name, CircuitBreakerConfig config) {
        return CircuitBreaker.of((String)name, (CircuitBreakerConfig)config);
    }

    public static CircuitBreaker noopCircuitBreaker() {
        CircuitBreakerConfig config = CircuitBreakerConfig.custom().slidingWindowSize(1).failureRateThreshold(100.0f).build();
        return ResilienceConfig.createCircuitBreaker("noop", config);
    }

    public static Retry createRetry(String name, Predicate<Throwable> retryOnException) {
        RetryConfig config = RetryConfig.custom().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialBackoff((long)5000L, (double)2.0)).retryOnException(retryOnException).build();
        return ResilienceConfig.createRetry(name, config);
    }

    public static Retry createRetry(String name, RetryConfig config) {
        return Retry.of((String)name, (RetryConfig)config);
    }

    public static Retry noopRetry() {
        RetryConfig config = RetryConfig.custom().maxAttempts(1).build();
        return ResilienceConfig.createRetry("noop", config);
    }
}

