/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.apache;

import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import uk.ac.warwick.util.ais.core.helpers.AisApimConstants;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;
import uk.ac.warwick.util.ais.core.properties.AisApimProperties;
import uk.ac.warwick.util.collections.Pair;

public class DefaultHttpRequestBuilder
implements HttpRequestBuilder<HttpUriRequest> {
    private final AisJsonConverter jsonConverter;
    private final AisApimProperties properties;

    public DefaultHttpRequestBuilder(AisJsonConverter jsonConverter, AisApimProperties properties) {
        this.jsonConverter = jsonConverter;
        this.properties = properties;
    }

    @Override
    public HttpUriRequest buildHttpRequest(String method, AisHttpRequest request) {
        RequestBuilder builder = RequestBuilder.create((String)method).setUri(this.getUri(this.properties.getBaseUrl(), request.getPath()));
        if (request.getBody() != null) {
            builder.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(this.jsonConverter.toJsonString(request.getBody())).build());
        }
        request.getQueryParams().forEach(item -> builder.addParameter((String)item.getLeft(), (String)item.getRight()));
        this.getAisRequiredHeaders(request).forEach(item -> builder.setHeader((String)item.getLeft(), (String)item.getRight()));
        request.getHeaders().forEach(item -> builder.setHeader((String)item.getLeft(), (String)item.getRight()));
        return builder.build();
    }

    protected List<Pair<String, String>> getAisRequiredHeaders(AisHttpRequest request) {
        ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        headers.add(new Pair((Object)"bapi-correlation-id", (Object)request.getCorrelationId()));
        headers.add(new Pair((Object)"bapi-channel-id", (Object)this.properties.getBapiChannelId()));
        headers.add(new Pair((Object)"bapi-app-id", (Object)this.properties.getBapiAppId()));
        headers.add(new Pair((Object)"bapi-request-id", (Object)request.getRequestId()));
        headers.add(new Pair((Object)"bapi-request-timestamp", (Object)LocalDateTime.now(ZoneOffset.UTC).format(AisApimConstants.BAPI_REQ_TIMESTAMP_FORMAT)));
        return headers;
    }

    private String getUri(String baseUrl, String path) {
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new IllegalArgumentException("baseUrl cannot be null or empty.");
        }
        try {
            String encodedPath = new URIBuilder().setPath(path).build().toString();
            return StringUtils.removeEnd((String)baseUrl, (String)"/").concat("/").concat(StringUtils.removeStart((String)encodedPath, (String)"/"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("path is not a valid URI.", e);
        }
    }
}

