/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.apache;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.httpclient.AbstractAisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;

public class DefaultAisHttpResponseHandler
extends AbstractAisHttpResponseHandler<HttpResponse> {
    private static final String EMPTY_ARRAY_JSON = "[]";

    public DefaultAisHttpResponseHandler(AisJsonConverter jsonConverter) {
        super(jsonConverter);
    }

    @Override
    protected JsonNode handleResponseEntity(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            String responseBody = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
            throw new AisHttpException(AisHttpException.ErrorType.HTTP_STATUS_CODE_ERROR, statusLine.getReasonPhrase(), statusLine.getStatusCode(), responseBody);
        }
        if (entity == null) {
            return this.jsonConverter.toJsonNode(EMPTY_ARRAY_JSON);
        }
        String mimeType = ContentType.get((HttpEntity)entity).getMimeType();
        String bodyString = EntityUtils.toString((HttpEntity)entity);
        return this.handleEntity(bodyString, mimeType);
    }
}

