/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.model;

import java.time.Instant;
import uk.ac.warwick.util.ais.auth.model.AuthenticationResult;
import uk.ac.warwick.util.ais.auth.token.AccessToken;

public class ClientCredentialsResult
implements AuthenticationResult {
    private final String scope;
    private final String accessToken;
    private final String tokenType;
    private final Instant expiryTime;

    public ClientCredentialsResult(String scope, AccessToken accessToken) {
        this.scope = scope;
        this.accessToken = accessToken.getTokenValue();
        this.tokenType = accessToken.getTokenType();
        this.expiryTime = accessToken.getExpiryTime();
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public boolean isExpired() {
        return this.expiryTime.isBefore(Instant.now());
    }

    @Override
    public boolean isExpiringAfter(int seconds) {
        return this.expiryTime.isBefore(Instant.now().plusSeconds(seconds));
    }

    public String getScope() {
        return this.scope;
    }
}

