/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim.stutalk.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import scala.collection.Iterable;
import uk.ac.warwick.util.ais.apim.stutalk.json.StuTalkJsonConverter;
import uk.ac.warwick.util.ais.apim.stutalk.json.StuTalkProperties;
import uk.ac.warwick.util.ais.core.exception.AisJsonProcessingException;
import uk.ac.warwick.util.ais.core.json.AbstractAisJsonConverter;

public class StuTalkJsonConverterImpl
extends AbstractAisJsonConverter
implements StuTalkJsonConverter {
    public StuTalkJsonConverterImpl(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public <T> T fromJsonNode(JsonNode json, TypeReference<T> typeReference) {
        if (json == null) {
            throw new IllegalArgumentException("jsonNode must not be null.");
        }
        List<String> properties = this.getStuTalkProperties(typeReference);
        return super.fromJsonNode(this.unwrap(json, properties), typeReference);
    }

    @Override
    public <T> T fromJsonNode(JsonNode json, Class<T> clazz) {
        if (json == null) {
            throw new IllegalArgumentException("jsonNode must not be null.");
        }
        List<String> properties = this.getStuTalkProperties(clazz);
        return super.fromJsonNode(this.unwrap(json, properties), clazz);
    }

    @Override
    public <T> T fromJsonString(String json, TypeReference<T> typeReference) {
        if (json == null) {
            throw new IllegalArgumentException("json string must not be null.");
        }
        List<String> properties = this.getStuTalkProperties(typeReference);
        JsonNode unwrappedNodes = this.unwrap(this.toJsonNode(json), properties);
        return super.fromJsonNode(unwrappedNodes, typeReference);
    }

    @Override
    public <T> T fromJsonString(String json, Class<T> clazz) {
        if (json == null) {
            throw new IllegalArgumentException("json string must not be null.");
        }
        List<String> properties = this.getStuTalkProperties(clazz);
        JsonNode unwrappedNodes = this.unwrap(this.toJsonNode(json), properties);
        return super.fromJsonNode(unwrappedNodes, clazz);
    }

    @Override
    public String toJsonString(Object obj) {
        if (obj == null) {
            return "{}";
        }
        List<String> properties = this.getStuTalkProperties(obj);
        return super.toJsonString(this.wrap(this.objectMapper.valueToTree(obj), Lists.reverse(properties)));
    }

    private JsonNode wrap(JsonNode jsonNode, List<String> properties) {
        JsonNode result = jsonNode;
        for (String property : properties) {
            result = this.objectMapper.createObjectNode().set(property, result);
        }
        return result;
    }

    private JsonNode unwrap(JsonNode jsonNode, List<String> properties) {
        JsonNode result = jsonNode;
        for (String property : properties) {
            try {
                result = Objects.nonNull(result.get(property)) ? result.get(property) : result;
            }
            catch (Exception e) {
                throw new AisJsonProcessingException("Unwrap json failed.", e);
            }
        }
        return result;
    }

    private List<String> getStuTalkProperties(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = this.getClassType(value);
        StuTalkProperties annotation = clazz.getAnnotation(StuTalkProperties.class);
        return annotation != null ? Arrays.asList(annotation.values()) : Collections.emptyList();
    }

    private Class<?> getClassType(Object value) {
        if (value instanceof java.lang.Iterable) {
            return Iterables.get((java.lang.Iterable)((java.lang.Iterable)value), (int)0).getClass();
        }
        if (value instanceof Iterable) {
            return ((Iterable)value).head().getClass();
        }
        if (value instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)value;
            if (typeReference.getType() instanceof ParameterizedType) {
                Type type = ((ParameterizedType)typeReference.getType()).getActualTypeArguments()[0];
                return (Class)type;
            }
            return (Class)typeReference.getType();
        }
        if (value instanceof Class) {
            return (Class)value;
        }
        return value.getClass();
    }
}

