/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.typesafe.config.ConfigException;
import java.util.function.Function;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import play.api.Configuration;
import uk.ac.warwick.util.ais.apim.config.AisSpringConfiguration;
import uk.ac.warwick.util.ais.apim.rodb.RodbHttpClient;
import uk.ac.warwick.util.ais.apim.stutalk.StuTalkHttpClient;
import uk.ac.warwick.util.ais.auth.Authenticator;
import uk.ac.warwick.util.ais.auth.credentials.OAuth2ClientCredentials;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsRequest;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsResult;
import uk.ac.warwick.util.ais.auth.model.OAuth2TokenFetchParameters;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.auth.token.TokenCache;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpAsyncClient;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestExecutor;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;
import uk.ac.warwick.util.ais.core.properties.AisApimProperties;

public class AisPlayModule
extends AbstractModule {
    private final AisSpringConfiguration configTemplate = new AisSpringConfiguration();

    protected void configure() {
    }

    @Named(value="aisApacheHttpAsyncClient")
    @Provides
    @Singleton
    public CloseableHttpAsyncClient provideHttpAsyncClient(Configuration configuration) {
        Integer maxConnections = this.getConfigIntOrDefault(configuration, "ais.apim.http.maxConnections", 10);
        return this.configTemplate.httpAsyncClient(maxConnections);
    }

    @Named(value="stuTalkObjectMapper")
    @Provides
    @Singleton
    public ObjectMapper provideStuTalkObjectMapper(Configuration configuration) {
        boolean emptyStringToNull = this.getConfigBooleanOrDefault(configuration, "ais.apim.objectMapper.emptyStringToNull", true);
        boolean normaliseNewline = this.getConfigBooleanOrDefault(configuration, "ais.apim.objectMapper.normaliseNewline", false);
        return this.configTemplate.stuTalkObjectMapper(emptyStringToNull, normaliseNewline);
    }

    @Named(value="stuTalkJsonConverter")
    @Provides
    @Singleton
    public AisJsonConverter provideStuTalkJsonConverter(@Named(value="stuTalkObjectMapper") ObjectMapper objectMapper) {
        return this.configTemplate.stuTalkJsonConverter(objectMapper);
    }

    @Named(value="aisHttpResponseHandler")
    @Provides
    @Singleton
    public AisHttpResponseHandler<HttpResponse> provideAisHttpResponseHandler(@Named(value="stuTalkJsonConverter") AisJsonConverter stuTalkJsonConverter) {
        return this.configTemplate.aisHttpResponseHandler(stuTalkJsonConverter);
    }

    @Named(value="aisHttpRequestExecutor")
    @Provides
    @Singleton
    public HttpRequestExecutor<HttpUriRequest, HttpResponse> provideAisHttpRequestExecutor(@Named(value="aisApacheHttpAsyncClient") CloseableHttpAsyncClient httpAsyncClient) {
        return this.configTemplate.aisHttpRequestExecutor(httpAsyncClient);
    }

    @Named(value="aisOAuth2ClientCredentials")
    @Provides
    @Singleton
    public OAuth2ClientCredentials provideOAuth2ClientCredentials(Configuration configuration) {
        String authority = this.getConfigString(configuration, "ais.apim.auth.oauth2.auth_url");
        String clientId = this.getConfigString(configuration, "ais.apim.auth.oauth2.client_id");
        String clientSecret = this.getConfigString(configuration, "ais.apim.auth.oauth2.client_secret");
        return this.configTemplate.aisOAuth2ClientCredentials(authority, clientId, clientSecret);
    }

    @Named(value="aisAuthTokenCache")
    @Provides
    @Singleton
    public TokenCache provideAisAuthTokenCache() {
        return this.configTemplate.aisAuthTokenCache();
    }

    @Named(value="aisAuthTokenFetcher")
    @Provides
    @Singleton
    public Function<OAuth2TokenFetchParameters, AccessToken> provideAisAuthTokenFetcher(@Named(value="stuTalkObjectMapper") ObjectMapper objectMapper, @Named(value="aisHttpRequestExecutor") HttpRequestExecutor<HttpUriRequest, HttpResponse> httpRequestExecutor) {
        return this.configTemplate.aisAuthTokenFetcher(objectMapper, httpRequestExecutor);
    }

    @Named(value="aisAuthenticator")
    @Provides
    @Singleton
    public Authenticator<ClientCredentialsRequest, ClientCredentialsResult> provideAisAuthenticator(@Named(value="aisOAuth2ClientCredentials") OAuth2ClientCredentials credentials, @Named(value="aisAuthTokenFetcher") Function<OAuth2TokenFetchParameters, AccessToken> tokenFetcher, @Named(value="aisAuthTokenCache") TokenCache tokenCache) {
        return this.configTemplate.aisAuthenticator(credentials, tokenFetcher, tokenCache);
    }

    @Named(value="aisApimProperties")
    @Provides
    @Singleton
    public AisApimProperties provideAisApimProperties(Configuration configuration) {
        String bapiChannelId = this.getConfigString(configuration, "ais.apim.headers.bapi-channel-id");
        String bapiAppId = this.getConfigString(configuration, "ais.apim.headers.bapi-app-id");
        String baseUrl = this.getConfigString(configuration, "ais.apim.base-url");
        return this.configTemplate.aisApimProperties(bapiChannelId, bapiAppId, baseUrl);
    }

    @Named(value="aisHttpRequestBuilder")
    @Provides
    @Singleton
    public HttpRequestBuilder<HttpUriRequest> provideAisHttpRequestBuilder(@Named(value="stuTalkJsonConverter") AisJsonConverter jsonConverter, @Named(value="aisApimProperties") AisApimProperties aisApimProperties) {
        return this.configTemplate.aisHttpRequestBuilder(jsonConverter, aisApimProperties);
    }

    @Named(value="aisAuthHttpRequestBuilder")
    @Provides
    @Singleton
    public HttpRequestBuilder<HttpUriRequest> provideAisAuthHttpRequestBuilder(Configuration configuration, @Named(value="aisAuthenticator") Authenticator<ClientCredentialsRequest, ClientCredentialsResult> authenticator, @Named(value="aisHttpRequestBuilder") HttpRequestBuilder<HttpUriRequest> requestBuilder) {
        String defaultScope = this.getConfigString(configuration, "ais.apim.auth.oauth2.scope");
        return this.configTemplate.aisAuthHttpRequestBuilder(defaultScope, authenticator, requestBuilder);
    }

    @Named(value="aisHttpAsyncClient")
    @Provides
    @Singleton
    public AisHttpAsyncClient provideAisHttpAsyncClient(@Named(value="aisAuthHttpRequestBuilder") HttpRequestBuilder<HttpUriRequest> aisAuthHttpRequestBuilder, @Named(value="aisHttpResponseHandler") AisHttpResponseHandler<HttpResponse> responseHandler, @Named(value="aisHttpRequestExecutor") HttpRequestExecutor<HttpUriRequest, HttpResponse> httpRequestExecutor, @Named(value="stuTalkObjectMapper") ObjectMapper objectMapper) {
        return this.configTemplate.aisHttpAsyncClient(aisAuthHttpRequestBuilder, responseHandler, httpRequestExecutor, objectMapper);
    }

    @Named(value="stuTalkHttpClient")
    @Provides
    @Singleton
    public StuTalkHttpClient provideStuTalkHttpClient(@Named(value="aisHttpAsyncClient") AisHttpAsyncClient aisHttpAsyncClient) {
        return this.configTemplate.stuTalkHttpClient(aisHttpAsyncClient);
    }

    @Named(value="rodbHttpClient")
    @Provides
    @Singleton
    public RodbHttpClient provideRodbHttpClient(@Named(value="aisHttpAsyncClient") AisHttpAsyncClient aisHttpAsyncClient) {
        return this.configTemplate.rodbHttpClient(aisHttpAsyncClient);
    }

    private String getConfigString(Configuration configuration, String key) {
        return configuration.underlying().getString(key);
    }

    private Integer getConfigIntOrDefault(Configuration configuration, String key, Integer defaultValue) {
        try {
            return configuration.underlying().getInt(key);
        }
        catch (ConfigException.Missing e) {
            return defaultValue;
        }
    }

    private boolean getConfigBooleanOrDefault(Configuration configuration, String key, boolean defaultValue) {
        try {
            return configuration.underlying().getBoolean(key);
        }
        catch (ConfigException.Missing e) {
            return defaultValue;
        }
    }
}

