/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.json.EmptyStringToNullTransformer;
import uk.ac.warwick.util.ais.core.json.PipelineStringDeserializer;
import uk.ac.warwick.util.ais.core.json.StringTransformer;
import uk.ac.warwick.util.ais.core.json.TransformerPipelineFactory;

public class PipelineStringDeserializerTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private PipelineStringDeserializer deserializer;
    private final String json = "{\n        \"mapc\": \"CH910-10\",\n        \"mabs\": \"\",\n        \"desc\": \"Neque porro quisquam est qui\\\\n dolorem ipsum quia dolor sit amet,\\n consectetur, adipisci velit...\"\n      }";

    @Test
    public void deserialize_emptyStringOnly_returnNull() throws IOException {
        EmptyStringToNullTransformer transformer = new EmptyStringToNullTransformer();
        this.deserializer = new PipelineStringDeserializer((StringTransformer)transformer);
        JsonNode jsonNode = this.objectMapper.readTree("{\n        \"mapc\": \"CH910-10\",\n        \"mabs\": \"\",\n        \"desc\": \"Neque porro quisquam est qui\\\\n dolorem ipsum quia dolor sit amet,\\n consectetur, adipisci velit...\"\n      }");
        JsonParser emptyNode = jsonNode.get("mabs").traverse();
        emptyNode.nextToken();
        JsonParser stringNode = jsonNode.get("desc").traverse();
        stringNode.nextToken();
        Assert.assertEquals((Object)"Neque porro quisquam est qui\\n dolorem ipsum quia dolor sit amet,\n consectetur, adipisci velit...", (Object)this.deserializer.deserialize(stringNode, null));
        Assert.assertNull((Object)this.deserializer.deserialize(emptyNode, null));
    }

    @Test
    public void deserialize_normalizeNewLineValueOnly_returnConvertedValue() throws IOException {
        StringTransformer transformer = TransformerPipelineFactory.createDeserializer((boolean)false, (boolean)true);
        this.deserializer = new PipelineStringDeserializer(transformer);
        JsonNode jsonNode = this.objectMapper.readTree("{\n        \"mapc\": \"CH910-10\",\n        \"mabs\": \"\",\n        \"desc\": \"Neque porro quisquam est qui\\\\n dolorem ipsum quia dolor sit amet,\\n consectetur, adipisci velit...\"\n      }");
        JsonParser emptyNode = jsonNode.get("mabs").traverse();
        JsonParser stringNode = jsonNode.get("desc").traverse();
        stringNode.nextToken();
        emptyNode.nextToken();
        Assert.assertEquals((Object)"Neque porro quisquam est qui\r\n dolorem ipsum quia dolor sit amet,\r\n consectetur, adipisci velit...", (Object)this.deserializer.deserialize(stringNode, null));
        Assert.assertEquals((Object)"", (Object)this.deserializer.deserialize(emptyNode, null));
    }

    @Test
    public void deserialize_mixedPipeline_returnConvertedValue() throws IOException {
        StringTransformer transformer = TransformerPipelineFactory.createDeserializer((boolean)true, (boolean)true);
        this.deserializer = new PipelineStringDeserializer(transformer);
        JsonNode jsonNode = this.objectMapper.readTree("{\n        \"mapc\": \"CH910-10\",\n        \"mabs\": \"\",\n        \"desc\": \"Neque porro quisquam est qui\\\\n dolorem ipsum quia dolor sit amet,\\n consectetur, adipisci velit...\"\n      }");
        JsonParser emptyNode = jsonNode.get("mabs").traverse();
        JsonParser stringNode = jsonNode.get("desc").traverse();
        stringNode.nextToken();
        emptyNode.nextToken();
        Assert.assertNull((Object)this.deserializer.deserialize(emptyNode, null));
        Assert.assertEquals((Object)"Neque porro quisquam est qui\r\n dolorem ipsum quia dolor sit amet,\r\n consectetur, adipisci velit...", (Object)this.deserializer.deserialize(stringNode, null));
    }
}

