/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.core.json.EmptyStringToNullTransformer;
import uk.ac.warwick.util.ais.core.json.PipelineStringDeserializer;
import uk.ac.warwick.util.ais.core.json.StringTransformer;

public class EmptyStringToNullDeserialiserTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final EmptyStringToNullTransformer transformer = new EmptyStringToNullTransformer();
    private final PipelineStringDeserializer deserialiser = new PipelineStringDeserializer((StringTransformer)this.transformer);

    @Test
    public void deserialize_notEmptyString_returnStringValue() throws IOException {
        String json = "{\n  \"SAB_OFF\": \"2018-10-03T07:24:14.772+03:00\",\n  \"SAB_EMPTY\": \"\"\n}";
        JsonNode jsonNode = this.objectMapper.readTree(json);
        JsonParser noneEmptyNode = jsonNode.get("SAB_OFF").traverse();
        noneEmptyNode.nextToken();
        Assert.assertEquals((Object)"2018-10-03T07:24:14.772+03:00", (Object)this.deserialiser.deserialize(noneEmptyNode, null));
    }

    @Test
    public void deserialize_emptyString_returnNull() throws IOException {
        String json = "{\n  \"SAB_OFF\": \"2018-10-03T07:24:14.772+03:00\",\n  \"SAB_EMPTY\": \"\"\n}";
        JsonNode jsonNode = this.objectMapper.readTree(json);
        JsonParser emptyNode = jsonNode.get("SAB_EMPTY").traverse();
        emptyNode.nextToken();
        Assert.assertNull((Object)this.deserialiser.deserialize(emptyNode, null));
    }
}

