/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.httpclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.http.HttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.httpclient.AbstractAisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;

public class AbstractAisHttpResponseHandlerTest {
    private AisJsonConverter jsonConverter;
    private final AbstractAisHttpResponseHandler<HttpResponse> defaultHandler;

    public AbstractAisHttpResponseHandlerTest() {
        this.defaultHandler = new AbstractAisHttpResponseHandler<HttpResponse>(this.jsonConverter){

            protected JsonNode handleResponseEntity(HttpResponse response) throws IOException {
                return null;
            }
        };
    }

    @Before
    public void setUp() {
        this.jsonConverter = (AisJsonConverter)Mockito.mock(AisJsonConverter.class);
    }

    @Test(expected=AisHttpException.class)
    public void handleResponse_IOException_throwAisHttpException() {
        AbstractAisHttpResponseHandler<HttpResponse> handler = new AbstractAisHttpResponseHandler<HttpResponse>(this.jsonConverter){

            protected JsonNode handleResponseEntity(HttpResponse response) throws IOException {
                throw new IOException("Test exception");
            }
        };
        handler.handleResponse(Mockito.mock(HttpResponse.class), (TypeReference)new TypeReference<String>(){});
    }

    @Test
    public void handleResponse_success() {
        TextNode jsonNode = JsonNodeFactory.instance.textNode("test");
        TypeReference<String> typeReference = new TypeReference<String>(){};
        AbstractAisHttpResponseHandler<HttpResponse> handler = new AbstractAisHttpResponseHandler<HttpResponse>(this.jsonConverter, (JsonNode)jsonNode){
            final /* synthetic */ JsonNode val$jsonNode;
            {
                this.val$jsonNode = jsonNode;
                super(x0);
            }

            protected JsonNode handleResponseEntity(HttpResponse response) throws IOException {
                return this.val$jsonNode;
            }
        };
        Mockito.when((Object)this.jsonConverter.fromJsonNode((JsonNode)jsonNode, (TypeReference)typeReference)).thenReturn((Object)"test");
        String result = (String)handler.handleResponse(Mockito.mock(HttpResponse.class), (TypeReference)typeReference);
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void handleError_AisHttpException_returnAisHttpException() {
        AisHttpException aisHttpException = new AisHttpException(AisHttpException.ErrorType.CONNECTION_ERROR, "Network exception occurred.", (Throwable)new RuntimeException("Test exception"));
        AisHttpException result = this.defaultHandler.handleError((Throwable)aisHttpException);
        Assert.assertEquals((Object)aisHttpException, (Object)result);
    }

    @Test
    public void handleError_SocketException_returnAisHttpException() {
        AisHttpException result = this.defaultHandler.handleError((Throwable)new SocketException());
        Assert.assertEquals((Object)AisHttpException.ErrorType.CONNECTION_ERROR, (Object)result.getErrorType());
        Assert.assertEquals((Object)"(errorType=CONNECTION_ERROR,message=Network exception occurred.)", (Object)result.getMessage());
    }

    @Test
    public void handleError_InterruptedIOException_returnAisHttpException() {
        AisHttpException result = this.defaultHandler.handleError((Throwable)new InterruptedIOException());
        Assert.assertEquals((Object)AisHttpException.ErrorType.CONNECTION_ERROR, (Object)result.getErrorType());
        Assert.assertEquals((Object)"(errorType=CONNECTION_ERROR,message=Network exception occurred.)", (Object)result.getMessage());
    }

    @Test
    public void handleError_OtherException_returnAisHttpException() {
        AisHttpException result = this.defaultHandler.handleError((Throwable)new RuntimeException());
        Assert.assertEquals((Object)AisHttpException.ErrorType.OTHERS, (Object)result.getErrorType());
        Assert.assertEquals((Object)"(errorType=OTHERS,message=An error occurred while communicating with AIS API Management Service.)", (Object)result.getMessage());
    }
}

