/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.helpers;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.warwick.util.ais.auth.Authenticator;
import uk.ac.warwick.util.ais.auth.OAuth2ClientCredentialsAuthenticator;
import uk.ac.warwick.util.ais.auth.exception.AuthenticationException;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsRequest;
import uk.ac.warwick.util.ais.auth.model.ClientCredentialsResult;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.core.helpers.AisHttpRequestAuthorizer;
import uk.ac.warwick.util.ais.core.httpclient.AisHttpRequest;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestBuilder;
import uk.ac.warwick.util.collections.Pair;

public class AisHttpRequestAuthorizerTest {
    private static final String DEFAULT_SCOPE = "default-scope";
    private static final String TEST_METHOD = "GET";
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private final AisHttpRequest request = new AisHttpRequest.Builder().path("path").build();
    private final ClientCredentialsResult result = new ClientCredentialsResult("default-scope", new AccessToken("test-token", "Bearer", Long.valueOf(1800L)));
    private OAuth2ClientCredentialsAuthenticator authenticator;

    @Before
    public void setUp() {
        this.authenticator = (OAuth2ClientCredentialsAuthenticator)Mockito.mock(OAuth2ClientCredentialsAuthenticator.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructor_DefaultScopeIsNull_ThrowException() {
        HttpRequestBuilder delegate = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        new AisHttpRequestAuthorizer(null, (Authenticator)this.authenticator, delegate);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructor_DefaultScopeIsEmpty_ThrowException() {
        HttpRequestBuilder delegate = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        new AisHttpRequestAuthorizer("", (Authenticator)this.authenticator, delegate);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructor_AuthenticatorIsNull_ThrowException() {
        HttpRequestBuilder delegate = (method, req) -> (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        new AisHttpRequestAuthorizer(DEFAULT_SCOPE, null, delegate);
    }

    @Test(expected=IllegalArgumentException.class)
    public void constructor_DelegateBuilderIsNull_ThrowException() {
        new AisHttpRequestAuthorizer(DEFAULT_SCOPE, (Authenticator)this.authenticator, null);
    }

    @Test
    public void buildHttpRequest_shouldAddAuthorizationHeader() {
        Mockito.when((Object)this.authenticator.authenticate((ClientCredentialsRequest)Mockito.any(ClientCredentialsRequest.class))).thenReturn((Object)this.result);
        HttpUriRequest finalRequest = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        AtomicBoolean isDelegateCalled = new AtomicBoolean(false);
        HttpRequestBuilder delegate = (method, req) -> {
            isDelegateCalled.set(true);
            return finalRequest;
        };
        AisHttpRequestAuthorizer authorizer = new AisHttpRequestAuthorizer(DEFAULT_SCOPE, (Authenticator)this.authenticator, delegate);
        HttpUriRequest httpUriRequest = (HttpUriRequest)authorizer.buildHttpRequest(TEST_METHOD, this.request);
        ((OAuth2ClientCredentialsAuthenticator)Mockito.verify((Object)this.authenticator)).authenticate((ClientCredentialsRequest)Mockito.any(ClientCredentialsRequest.class));
        Pair token = this.request.getHeaders().stream().filter(x -> ((String)x.getLeft()).equals(AUTHORIZATION_HEADER_KEY)).findFirst().orElse(null);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)"Bearer test-token", (Object)token.getRight());
        Assert.assertEquals((Object)finalRequest, (Object)httpUriRequest);
        Assert.assertTrue((boolean)isDelegateCalled.get());
    }

    @Test
    public void buildHttpRequest_authenticationFailed_throwException() {
        Mockito.when((Object)this.authenticator.authenticate((ClientCredentialsRequest)Mockito.any(ClientCredentialsRequest.class))).thenThrow(new Throwable[]{new AuthenticationException("Authentication failed", null)});
        HttpUriRequest finalRequest = (HttpUriRequest)Mockito.mock(HttpUriRequest.class);
        AtomicBoolean isDelegateCalled = new AtomicBoolean(false);
        HttpRequestBuilder delegate = (method, req) -> {
            isDelegateCalled.set(true);
            return finalRequest;
        };
        AisHttpRequestAuthorizer authorizer = new AisHttpRequestAuthorizer(DEFAULT_SCOPE, (Authenticator)this.authenticator, delegate);
        try {
            authorizer.buildHttpRequest(TEST_METHOD, this.request);
            Assert.fail((String)"Should throw an exception");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof AuthenticationException));
            ((OAuth2ClientCredentialsAuthenticator)Mockito.verify((Object)this.authenticator)).authenticate((ClientCredentialsRequest)Mockito.any(ClientCredentialsRequest.class));
            Assert.assertFalse((boolean)isDelegateCalled.get());
        }
    }
}

