/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.core.apache;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import uk.ac.warwick.util.ais.core.apache.DefaultAisHttpResponseHandler;
import uk.ac.warwick.util.ais.core.exception.AisHttpException;
import uk.ac.warwick.util.ais.core.json.AisJsonConverter;

public class DefaultAisHttpResponseHandlerTest {
    private AisJsonConverter jsonConverter;
    private DefaultAisHttpResponseHandler handler;

    @Before
    public void setUp() {
        this.jsonConverter = (AisJsonConverter)Mockito.mock(AisJsonConverter.class);
        this.handler = new DefaultAisHttpResponseHandler(this.jsonConverter);
    }

    @Test
    public void handleResponseEntity_validResponse_returnsJsonNode() throws IOException {
        String jsonString = "{\"key\":\"value\"}";
        BasicHttpResponse successResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        successResponse.setEntity((HttpEntity)this.createHttpEntity(jsonString));
        Mockito.when((Object)this.jsonConverter.toJsonNode(jsonString)).thenReturn(Mockito.mock(JsonNode.class));
        JsonNode result = this.handler.handleResponseEntity((HttpResponse)successResponse);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void handleResponseEntity_entityIsNull_returnsEmptyArrayJsonNode() throws IOException {
        BasicHttpResponse successResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        successResponse.setEntity(null);
        Mockito.when((Object)this.jsonConverter.toJsonNode(Mockito.anyString())).thenReturn(Mockito.mock(JsonNode.class));
        JsonNode result = this.handler.handleResponseEntity((HttpResponse)successResponse);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void handleResponseEntity_statusCodeIs3xx_throwAisHttpException() throws IOException {
        String jsonString = "{\"key\":\"value\"}";
        BasicHttpResponse errorResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 300, "Redirect");
        errorResponse.setEntity((HttpEntity)this.createHttpEntity(jsonString));
        try {
            this.handler.handleResponseEntity((HttpResponse)errorResponse);
            Assert.fail((String)"Expected AisHttpException to be thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof AisHttpException));
            Assert.assertEquals((Object)AisHttpException.ErrorType.HTTP_STATUS_CODE_ERROR, (Object)((AisHttpException)e).getErrorType());
            Assert.assertEquals((Object)jsonString, (Object)((AisHttpException)e).getResponseBody());
            ((AisJsonConverter)Mockito.verify((Object)this.jsonConverter, (VerificationMode)Mockito.never())).toJsonNode(jsonString);
        }
    }

    @Test
    public void handleResponseEntity_statusCodeIs4xxAndEntityIsNull_throwAisHttpException() throws IOException {
        BasicHttpResponse errorResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 400, "Bad Request");
        errorResponse.setEntity(null);
        try {
            this.handler.handleResponseEntity((HttpResponse)errorResponse);
            Assert.fail((String)"Expected AisHttpException to be thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof AisHttpException));
            Assert.assertEquals((Object)AisHttpException.ErrorType.HTTP_STATUS_CODE_ERROR, (Object)((AisHttpException)e).getErrorType());
            Assert.assertNull((Object)((AisHttpException)e).getResponseBody());
            ((AisJsonConverter)Mockito.verify((Object)this.jsonConverter, (VerificationMode)Mockito.never())).toJsonNode(Mockito.anyString());
        }
    }

    private BasicHttpEntity createHttpEntity(String content) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes());
        BasicHttpEntity httpEntity = new BasicHttpEntity();
        httpEntity.setContent((InputStream)inputStream);
        httpEntity.setContentLength((long)content.length());
        httpEntity.setContentType(ContentType.APPLICATION_JSON.toString());
        httpEntity.setContentEncoding((Header)new BasicHeader("Content-Encoding", "UTF-8"));
        return httpEntity;
    }
}

