/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.auth.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.ais.auth.credentials.OAuth2ClientCredentials;
import uk.ac.warwick.util.ais.auth.exception.TokenFetchException;
import uk.ac.warwick.util.ais.auth.model.OAuth2TokenFetchParameters;
import uk.ac.warwick.util.ais.auth.token.AccessToken;
import uk.ac.warwick.util.ais.auth.token.DefaultOAuth2TokenFetcher;
import uk.ac.warwick.util.ais.core.httpclient.HttpRequestExecutor;

public class DefaultOAuth2TokenFetcherTest {
    private static final OAuth2ClientCredentials credentials = new OAuth2ClientCredentials("authority", "clientId", "clientSecret");
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void apply_fetchTokenSuccess() {
        AtomicReference dumpRequest = new AtomicReference();
        HttpRequestExecutor requestExecutor = req -> {
            dumpRequest.set(req);
            return CompletableFuture.completedFuture(this.createHttpResponse());
        };
        DefaultOAuth2TokenFetcher aisOAuth2TokenFetcher = new DefaultOAuth2TokenFetcher(this.objectMapper, arg_0 -> ((HttpRequestExecutor)requestExecutor).execute(arg_0));
        OAuth2TokenFetchParameters parameters = new OAuth2TokenFetchParameters(credentials, "scope");
        AccessToken accessToken = aisOAuth2TokenFetcher.apply(parameters);
        Assert.assertNotNull((Object)accessToken);
        Assert.assertEquals((Object)"token", (Object)accessToken.getTokenValue());
        Assert.assertEquals((Object)"Bearer", (Object)accessToken.getTokenType());
        Assert.assertEquals((long)3600L, (long)accessToken.getExpiresIn());
        HttpUriRequest request = (HttpUriRequest)dumpRequest.get();
        Assert.assertEquals((Object)"POST", (Object)request.getMethod());
        Assert.assertEquals((Object)"authority", (Object)request.getURI().toString());
        Assert.assertTrue((boolean)(request instanceof HttpEntityEnclosingRequestBase));
        HttpEntityEnclosingRequestBase entityRequest = (HttpEntityEnclosingRequestBase)request;
        try {
            String entity = EntityUtils.toString((HttpEntity)entityRequest.getEntity());
            Assert.assertTrue((boolean)entity.contains("client_id=clientId"));
            Assert.assertTrue((boolean)entity.contains("client_secret=clientSecret"));
            Assert.assertTrue((boolean)entity.contains("scope=scope"));
            Assert.assertTrue((boolean)entity.contains("grant_type=client_credentials"));
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to read request entity");
        }
    }

    @Test(expected=TokenFetchException.class)
    public void apply_fetchTokenFailed_throwTokenFetchException() {
        BasicHttpResponse errorResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 400, "Bad Request");
        errorResponse.setEntity(null);
        HttpRequestExecutor requestExecutor = arg_0 -> DefaultOAuth2TokenFetcherTest.lambda$apply_fetchTokenFailed_throwTokenFetchException$1((HttpResponse)errorResponse, arg_0);
        DefaultOAuth2TokenFetcher aisOAuth2TokenFetcher = new DefaultOAuth2TokenFetcher(this.objectMapper, arg_0 -> ((HttpRequestExecutor)requestExecutor).execute(arg_0));
        OAuth2TokenFetchParameters parameters = new OAuth2TokenFetchParameters(credentials, "scope");
        aisOAuth2TokenFetcher.apply(parameters);
    }

    @Test(expected=TokenFetchException.class)
    public void apply_requestTimeout_throwTokenFetchException() {
        HttpRequestExecutor requestExecutor = req -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new SocketTimeoutException("Request timeout"));
            return future;
        };
        DefaultOAuth2TokenFetcher aisOAuth2TokenFetcher = new DefaultOAuth2TokenFetcher(this.objectMapper, arg_0 -> ((HttpRequestExecutor)requestExecutor).execute(arg_0));
        OAuth2TokenFetchParameters parameters = new OAuth2TokenFetchParameters(credentials, "scope");
        aisOAuth2TokenFetcher.apply(parameters);
    }

    private HttpResponse createHttpResponse() {
        String jsonToken = "{\"access_token\":\"token\",\"token_type\":\"Bearer\",\"expires_in\":3600}";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonToken.getBytes());
        BasicHttpEntity httpEntity = new BasicHttpEntity();
        httpEntity.setContent((InputStream)inputStream);
        httpEntity.setContentLength((long)jsonToken.length());
        httpEntity.setContentType(ContentType.APPLICATION_JSON.toString());
        httpEntity.setContentEncoding((Header)new BasicHeader("Content-Encoding", "UTF-8"));
        BasicHttpResponse successResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        successResponse.setEntity((HttpEntity)httpEntity);
        return successResponse;
    }

    private static /* synthetic */ CompletableFuture lambda$apply_fetchTokenFailed_throwTokenFetchException$1(HttpResponse errorResponse, HttpUriRequest req) {
        return CompletableFuture.completedFuture(errorResponse);
    }
}

