/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.ais.apim.stutalk.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters;
import uk.ac.warwick.util.ais.apim.stutalk.TestData;
import uk.ac.warwick.util.ais.apim.stutalk.json.StuTalkJsonConverter;
import uk.ac.warwick.util.ais.apim.stutalk.json.StuTalkJsonConverterImpl;
import uk.ac.warwick.util.ais.core.json.PipelineStringDeserializer;
import uk.ac.warwick.util.ais.core.json.PipelineStringSerializer;
import uk.ac.warwick.util.ais.core.json.TransformerPipelineFactory;

public class StuTalkJsonConverterImplTest {
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new DefaultScalaModule()).registerModule((Module)new JodaModule()).registerModule(this.buildCustomStutalkModule()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
    private final StuTalkJsonConverter converter = new StuTalkJsonConverterImpl(this.objectMapper);
    private final TypeReference<List<TestData>> typeReference = new TypeReference<List<TestData>>(){};
    private final String listTestData = "{\n   \"EXCHANGE\": {\n     \"SRA\": {\n       \"SRA.CAMS\": [\n         {\n           \"AYR_CODE.SRA.CAMS\": \"24/25\",\n           \"MAV_OCCUR.SRA.CAMS\": \"A\",\n           \"MOD_CODE.SRA.CAMS\": \"EN107-30\",\n           \"PSL_CODE.SRA.CAMS\": \"Y\",\n           \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n           \"SRA_RSEQ.SRA.CAMS\": \"001\"\n         }\n       ]\n     }\n   }\n}";
    private final String objTestData = "{\n    \"EXCHANGE\": {\n      \"SRA\": {\n        \"SRA.CAMS\": {\n            \"AYR_CODE.SRA.CAMS\": \"24/25\",\n            \"MAV_OCCUR.SRA.CAMS\": \"A\",\n            \"MOD_CODE.SRA.CAMS\": \"EN107-30\",\n            \"PSL_CODE.SRA.CAMS\": \"Y\",\n            \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n            \"SRA_RSEQ.SRA.CAMS\": \"001\"\n          }\n      }\n    }\n}";

    private Module buildCustomStutalkModule() {
        SimpleModule stutalkModule = new SimpleModule();
        stutalkModule.addSerializer(String.class, (JsonSerializer)new PipelineStringSerializer(TransformerPipelineFactory.createSerializer((boolean)true)));
        stutalkModule.addDeserializer(String.class, (JsonDeserializer)new PipelineStringDeserializer(TransformerPipelineFactory.createDeserializer((boolean)true, (boolean)true)));
        return stutalkModule;
    }

    @Test
    public void fromJsonNode_validJsonNode_returnsDeserializedObject() {
        JsonNode jsonNode = this.converter.toJsonNode("{\n   \"EXCHANGE\": {\n     \"SRA\": {\n       \"SRA.CAMS\": [\n         {\n           \"AYR_CODE.SRA.CAMS\": \"24/25\",\n           \"MAV_OCCUR.SRA.CAMS\": \"A\",\n           \"MOD_CODE.SRA.CAMS\": \"EN107-30\",\n           \"PSL_CODE.SRA.CAMS\": \"Y\",\n           \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n           \"SRA_RSEQ.SRA.CAMS\": \"001\"\n         }\n       ]\n     }\n   }\n}");
        List result = (List)this.converter.fromJsonNode(jsonNode, this.typeReference);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"24/25", (Object)((TestData)result.get(0)).getAyrCode());
        Assert.assertEquals((Object)"A", (Object)((TestData)result.get(0)).getMavOccur());
        Assert.assertEquals((Object)"EN107-30", (Object)((TestData)result.get(0)).getModCode());
        Assert.assertEquals((Object)"Y", (Object)((TestData)result.get(0)).getPslCode());
        Assert.assertEquals((Object)"5514251/1", (Object)((TestData)result.get(0)).getSprCode());
        Assert.assertEquals((Object)"001", (Object)((TestData)result.get(0)).getSraRseq());
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonNode_nullJsonNode_throwsIllegalArgumentException() {
        this.converter.fromJsonNode(null, this.typeReference);
    }

    @Test
    public void fromJsonNode_forClass_success() {
        JsonNode jsonNode = this.converter.toJsonNode("{\n    \"EXCHANGE\": {\n      \"SRA\": {\n        \"SRA.CAMS\": {\n            \"AYR_CODE.SRA.CAMS\": \"24/25\",\n            \"MAV_OCCUR.SRA.CAMS\": \"A\",\n            \"MOD_CODE.SRA.CAMS\": \"EN107-30\",\n            \"PSL_CODE.SRA.CAMS\": \"Y\",\n            \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n            \"SRA_RSEQ.SRA.CAMS\": \"001\"\n          }\n      }\n    }\n}");
        TestData result = (TestData)this.converter.fromJsonNode(jsonNode, TestData.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"24/25", (Object)result.getAyrCode());
        Assert.assertEquals((Object)"A", (Object)result.getMavOccur());
        Assert.assertEquals((Object)"EN107-30", (Object)result.getModCode());
        Assert.assertEquals((Object)"Y", (Object)result.getPslCode());
        Assert.assertEquals((Object)"5514251/1", (Object)result.getSprCode());
        Assert.assertEquals((Object)"001", (Object)result.getSraRseq());
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonNode_forClassWithNullJsonNode_throwsIllegalArgumentException() {
        this.converter.fromJsonNode(null, TestData.class);
    }

    @Test
    public void fromJsonString_validJsonString_returnsDeserializedObject() {
        List result = (List)this.converter.fromJsonString("{\n   \"EXCHANGE\": {\n     \"SRA\": {\n       \"SRA.CAMS\": [\n         {\n           \"AYR_CODE.SRA.CAMS\": \"24/25\",\n           \"MAV_OCCUR.SRA.CAMS\": \"A\",\n           \"MOD_CODE.SRA.CAMS\": \"EN107-30\",\n           \"PSL_CODE.SRA.CAMS\": \"Y\",\n           \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n           \"SRA_RSEQ.SRA.CAMS\": \"001\"\n         }\n       ]\n     }\n   }\n}", this.typeReference);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"24/25", (Object)((TestData)result.get(0)).getAyrCode());
        Assert.assertEquals((Object)"A", (Object)((TestData)result.get(0)).getMavOccur());
        Assert.assertEquals((Object)"EN107-30", (Object)((TestData)result.get(0)).getModCode());
        Assert.assertEquals((Object)"Y", (Object)((TestData)result.get(0)).getPslCode());
        Assert.assertEquals((Object)"5514251/1", (Object)((TestData)result.get(0)).getSprCode());
        Assert.assertEquals((Object)"001", (Object)((TestData)result.get(0)).getSraRseq());
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonString_nullJsonString_throwsIllegalArgumentException() {
        this.converter.fromJsonString(null, this.typeReference);
    }

    @Test
    public void fromJsonString_forClassWithValidJsonString_returnsDeserializedObject() {
        TestData result = (TestData)this.converter.fromJsonString("{\n    \"EXCHANGE\": {\n      \"SRA\": {\n        \"SRA.CAMS\": {\n            \"AYR_CODE.SRA.CAMS\": \"24/25\",\n            \"MAV_OCCUR.SRA.CAMS\": \"A\",\n            \"MOD_CODE.SRA.CAMS\": \"EN107-30\",\n            \"PSL_CODE.SRA.CAMS\": \"Y\",\n            \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n            \"SRA_RSEQ.SRA.CAMS\": \"001\"\n          }\n      }\n    }\n}", TestData.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"24/25", (Object)result.getAyrCode());
        Assert.assertEquals((Object)"A", (Object)result.getMavOccur());
        Assert.assertEquals((Object)"EN107-30", (Object)result.getModCode());
        Assert.assertEquals((Object)"Y", (Object)result.getPslCode());
        Assert.assertEquals((Object)"5514251/1", (Object)result.getSprCode());
        Assert.assertEquals((Object)"001", (Object)result.getSraRseq());
    }

    @Test
    public void fromJsonString_withNewLine_returnsDeserializedObject() {
        String newLineTestData = "{\n    \"EXCHANGE\": {\n      \"SRA\": {\n        \"SRA.CAMS\": {\n            \"AYR_CODE.SRA.CAMS\": \"24/25\",\n            \"MAV_OCCUR.SRA.CAMS\": \"\",\n            \"MOD_CODE.SRA.CAMS\": \"EN107\\n-30\",\n            \"PSL_CODE.SRA.CAMS\": \"Y\",\n            \"SPR_CODE.SRA.CAMS\": \"5514251/1\",\n            \"SRA_RSEQ.SRA.CAMS\": \"001\"\n          }\n      }\n    }\n}";
        TestData result = (TestData)this.converter.fromJsonString(newLineTestData, TestData.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"24/25", (Object)result.getAyrCode());
        Assert.assertNull((Object)result.getMavOccur());
        Assert.assertEquals((Object)"EN107\r\n-30", (Object)result.getModCode());
        Assert.assertEquals((Object)"Y", (Object)result.getPslCode());
        Assert.assertEquals((Object)"5514251/1", (Object)result.getSprCode());
        Assert.assertEquals((Object)"001", (Object)result.getSraRseq());
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromJsonString_forClassWithNullJsonString_throwsIllegalArgumentException() {
        this.converter.fromJsonString(null, TestData.class);
    }

    @Test
    public void toJsonString_listObject_returnsJsonString() {
        String exp = "{\"EXCHANGE\":{\"SRA\":{\"SRA.CAMS\":[{\"AYR_CODE.SRA.CAMS\":\"24/25\",\"MAV_OCCUR.SRA.CAMS\":\"A\",\"MOD_CODE.SRA.CAMS\":\"EN107-30\",\"PSL_CODE.SRA.CAMS\":\"Y\",\"SPR_CODE.SRA.CAMS\":\"5514251/1\",\"SRA_RSEQ.SRA.CAMS\":\"001\"}]}}}";
        TestData data = new TestData("24/25", "A", "EN107-30", "Y", "5514251/1", "001");
        String json = this.converter.toJsonString(Collections.singletonList(data));
        Assert.assertEquals((Object)exp, (Object)json);
    }

    @Test
    public void toJsonString_singleObject_returnsJsonString() {
        String exp = "{\"EXCHANGE\":{\"SRA\":{\"SRA.CAMS\":{\"AYR_CODE.SRA.CAMS\":\"24/25\",\"MAV_OCCUR.SRA.CAMS\":\"A\",\"MOD_CODE.SRA.CAMS\":\"EN107-30\",\"PSL_CODE.SRA.CAMS\":\"Y\",\"SPR_CODE.SRA.CAMS\":\"5514251/1\",\"SRA_RSEQ.SRA.CAMS\":\"001\"}}}}";
        TestData data = new TestData("24/25", "A", "EN107-30", "Y", "5514251/1", "001");
        String json = this.converter.toJsonString((Object)data);
        Assert.assertEquals((Object)exp, (Object)json);
    }

    @Test
    public void toJsonString_nullObject_returnsEmptyJsonObject() {
        String result = this.converter.toJsonString(null);
        Assert.assertEquals((Object)"{}", (Object)result);
    }

    @Test
    public void toJsonString_scalaCollections_returnsJsonString() {
        String exp = "{\"EXCHANGE\":{\"SRA\":{\"SRA.CAMS\":[{\"AYR_CODE.SRA.CAMS\":\"24/25\",\"MAV_OCCUR.SRA.CAMS\":\"A\",\"MOD_CODE.SRA.CAMS\":\"EN107-30\",\"PSL_CODE.SRA.CAMS\":\"Y\",\"SPR_CODE.SRA.CAMS\":\"5514251/1\",\"SRA_RSEQ.SRA.CAMS\":\"001\"}]}}}";
        TestData data = new TestData("24/25", "A", "EN107-30", "Y", "5514251/1", "001");
        Seq scalaSeq = CollectionConverters.CollectionHasAsScala(Collections.singletonList(data)).asScala().toSeq();
        String json = this.converter.toJsonString((Object)scalaSeq);
        Assert.assertEquals((Object)exp, (Object)json);
    }

    @Test
    public void toJsonString_normalizeNewLine_returnsJsonString() {
        String exp = "{\"EXCHANGE\":{\"SRA\":{\"SRA.CAMS\":{\"AYR_CODE.SRA.CAMS\":\"24/25\",\"MAV_OCCUR.SRA.CAMS\":\"A\",\"MOD_CODE.SRA.CAMS\":\"EN107-30\",\"PSL_CODE.SRA.CAMS\":\"Y\",\"SPR_CODE.SRA.CAMS\":\"5514251/1\",\"SRA_RSEQ.SRA.CAMS\":\"001\\n002\"}}}}";
        TestData data = new TestData("24/25", "A", "EN107-30", "Y", "5514251/1", "001\r\n002");
        String json = this.converter.toJsonString((Object)data);
        Assert.assertEquals((Object)exp, (Object)json);
    }
}

